/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension.util;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.xwiki.extension.Extension;
import org.xwiki.tool.extension.ExtensionOverride;
import org.xwiki.tool.extension.internal.ExtensionMojoCoreExtensionRepository;
import org.xwiki.tool.extension.util.ExtensionArtifact;
import org.xwiki.tool.extension.util.ExtensionMojoHelper;

public abstract class AbstractExtensionMojo
extends AbstractMojo {
    @Component
    protected PlexusContainer container;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="localRepository")
    protected ArtifactRepository localRepository;
    @Parameter
    protected List<ExtensionOverride> extensionOverrides;
    @Parameter
    protected boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/data/")
    protected File permanentDirectory;
    @Parameter(defaultValue="${xwiki.extension.recommendedVersions}")
    protected String recommendedVersions;
    protected ExtensionMojoHelper extensionHelper;
    @Component
    private ArtifactHandlerManager artifactHandlers;
    @Parameter
    private List<ExtensionArtifact> coreExtensions;
    @Parameter(property="project.remoteArtifactRepositories")
    private List<ArtifactRepository> remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipExecution()) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.before();
        try {
            this.executeInternal();
        }
        finally {
            this.after();
        }
    }

    protected boolean isSkipExecution() {
        return this.skip;
    }

    protected void before() throws MojoExecutionException {
        this.initializeExtensionMojoHelper();
        this.registerCoreExtensions();
        this.extensionHelper.getMavenBuildConfigurationSource().setProperty("extension.recommendedVersions", this.recommendedVersions);
    }

    protected void after() throws MojoExecutionException {
        this.extensionHelper.close();
    }

    protected abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    protected void initializeExtensionMojoHelper() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Initializing extension tools...");
        System.setProperty("org.slf4j.simpleLogger.log.org", "warn");
        System.setProperty("org.slf4j.simpleLogger.log.org.xwiki", "info");
        System.setProperty("org.slf4j.simpleLogger.log.org.xwiki.logging.logback", "error");
        this.extensionHelper = ExtensionMojoHelper.create(this.project, this.permanentDirectory);
        this.extensionHelper.initalize(this.session, this.localRepository, this.container);
        this.extensionHelper.setExtensionOverrides(this.extensionOverrides);
        this.getLog().info((CharSequence)"Done initializing extension tools");
    }

    private void registerCoreExtensions() throws MojoExecutionException {
        if (this.coreExtensions != null) {
            this.getLog().info((CharSequence)"Registering core extensions...");
            Set<Artifact> coreArtifacts = this.extensionHelper.collectMavenArtifacts(this.coreExtensions);
            if (coreArtifacts != null) {
                ExtensionMojoCoreExtensionRepository repository = this.extensionHelper.getExtensionMojoCoreExtensionRepository();
                for (Artifact artifact : coreArtifacts) {
                    ArtifactHandler artifactHandler = this.artifactHandlers.getArtifactHandler(artifact.getType());
                    if (!artifactHandler.isAddedToClasspath()) continue;
                    try {
                        Extension extension = this.extensionHelper.getExtension(artifact);
                        repository.addExtension(extension);
                    }
                    catch (Exception e) {
                        this.getLog().warn((CharSequence)("Failed to resolve details for artifact [" + artifact + "] (" + ExceptionUtils.getRootCauseMessage((Throwable)e) + "). Only considering the id."));
                        repository.addExtension(artifact);
                    }
                }
            }
            this.getLog().info((CharSequence)"Done registering core extensions");
        }
    }
}

