/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public abstract class AbstractPomCheck
implements EnforcerRule {
    protected MavenProject getMavenProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Failed to get Maven project", (Exception)((Object)e));
        }
        return project;
    }

    protected Model getModel(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Model model;
        MavenProject project = this.getMavenProject(helper);
        FileReader reader = null;
        try {
            reader = new FileReader(project.getFile());
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            model = xpp3Reader.read((Reader)reader);
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Failed to read pom file [" + project.getFile() + "]", e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception ee) {
                    throw new EnforcerRuleException("Failed to close stream after reading pom file [" + project.getFile() + "]", ee);
                }
            }
        }
        return model;
    }

    protected Model getResolvedModel(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project = this.getMavenProject(helper);
        return project.getModel();
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "";
    }
}

