/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.xwiki.tool.enforcer.AbstractPomCheck;

@Named(value="bannedDependencyType")
public class BannedDependencyType
extends AbstractPomCheck {
    private static final String JAR = "jar";
    private String projectGroupId;
    private String projectArtifactId;
    private String projectPackaging;
    private String dependencyType;

    public void execute() throws EnforcerRuleException {
        Model model = this.getModel();
        if (this.skipProjectPackaging(model)) {
            this.getLog().info((CharSequence)("Skipping as the packaging does not match [" + this.projectPackaging + "]"));
            return;
        }
        if (this.skipProjectGroupId(model)) {
            this.getLog().info((CharSequence)("Skipping as the group id does not match [" + this.projectGroupId + "]"));
            return;
        }
        if (this.skiphProjectArtifactId(model)) {
            this.getLog().info((CharSequence)("Skipping as the artifact id does not match [" + this.projectArtifactId + "]"));
            return;
        }
        for (Dependency dependency : model.getDependencies()) {
            if (!this.isRuntime(dependency) || !this.getType(dependency).equals(this.dependencyType)) continue;
            throw new EnforcerRuleException("Found dependency with banned type [" + this.dependencyType + "]: " + String.valueOf(dependency));
        }
    }

    private boolean skipPattern(String value, String pattern) {
        return pattern != null && !value.matches(pattern);
    }

    private boolean skipProjectPackaging(Model model) {
        return this.skipPattern(this.getPackaging(model), this.projectPackaging);
    }

    private boolean skipProjectGroupId(Model model) {
        return this.skipPattern(model.getGroupId(), this.projectGroupId);
    }

    private boolean skiphProjectArtifactId(Model model) {
        return this.skipPattern(model.getArtifactId(), this.projectArtifactId);
    }

    private boolean isRuntime(Dependency dependency) {
        return dependency.getScope() == null || dependency.getScope().equals("runtime") || dependency.getScope().equals("build");
    }

    private String getPackaging(Model model) {
        return model.getPackaging() != null ? model.getPackaging() : JAR;
    }

    private String getType(Dependency dependency) {
        return dependency.getType() != null ? dependency.getType() : JAR;
    }
}

