/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.xwiki.tool.enforcer.AbstractPomCheck;
import org.xwiki.tool.enforcer.VersionCheck;

@Named(value="validateDependencyVersion")
public class ValidateDependencyVersion
extends AbstractPomCheck {
    private List<VersionCheck> checks = new ArrayList<VersionCheck>();

    public void addVersionCheck(VersionCheck versionCheck) {
        this.checks.add(versionCheck);
    }

    public void execute() throws EnforcerRuleException {
        Model model = this.getModel();
        this.validateDependencies(model.getDependencies());
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement != null) {
            this.validateDependencies(dependencyManagement.getDependencies());
        }
    }

    private void validateDependencies(List dependencies) throws EnforcerRuleException {
        for (Object object : dependencies) {
            Dependency dependency = (Dependency)object;
            for (VersionCheck versionCheck : this.checks) {
                Pattern pattern;
                Matcher matcher;
                if (dependency.getVersion() == null || !dependency.getGroupId().startsWith(versionCheck.getGroupIdPrefix()) || (matcher = (pattern = Pattern.compile(versionCheck.getAllowedVersionRegex())).matcher(dependency.getVersion())).matches()) continue;
                throw new EnforcerRuleException("Was expecting a dependency version matching [" + versionCheck.getAllowedVersionRegex() + "] but got instead [" + dependency.getVersion() + "] for " + dependency);
            }
        }
    }
}

