/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.xwiki.tool.enforcer.AbstractPomCheck;

@Named(value="externalExtensionCheck")
public class ExternalExtensionCheck
extends AbstractPomCheck {
    private static final String CORE_GROUP_ID = "org.xwiki";
    private static final String CORE_GROUP_ID_PREFIX = "org.xwiki.";
    private static final String COMMONS_GROUP_ID = "org.xwiki.commons";
    private static final String RENDERING_GROUP_ID = "org.xwiki.rendering";
    private static final String PLATFORM_GROUP_ID = "org.xwiki.platform";
    private static final String ENTERPRISE_GROUP_ID = "org.xwiki.enterprise";
    private static final String CONTRIB_GROUP_ID = "org.xwiki.contrib";
    private static final String CONTRIB_GROUP_ID_PREFIX = "org.xwiki.contrib.";
    private static final List<String> CORE_GROUP_IDS = ExternalExtensionCheck.createCoreGroupIdsList();
    private static final String COMMONS_ARTIFACT_ID_PREFIX = "xwiki-commons";
    private static final String RENDERING_ARTIFACT_ID_PREFIX = "xwiki-rendering";
    private static final String PLATFORM_ARTIFACT_ID_PREFIX = "xwiki-platform";
    private static final String ENTERPRISE_ARTIFACT_ID_PREFIX = "xwiki-enterprise";
    private static final List<String> CORE_ARTIFACT_ID_PREFIXES = Arrays.asList("xwiki-commons", "xwiki-rendering", "xwiki-platform", "xwiki-enterprise");
    private static final String CORE_DEVELOPERS = "XWiki Development Team";

    public void execute() throws EnforcerRuleException {
        Model model = this.getResolvedModel();
        if (this.isXWikiCoreCommitterExtension(model)) {
            this.checkCoreArtifactId(model);
        } else {
            this.checkNonCoreGroupId(model);
            this.checkNonCoreArtifactId(model);
            this.checkNonCoreDevelopers(model);
        }
    }

    private static List<String> createCoreGroupIdsList() {
        ArrayList<String> reservedGroupIds = new ArrayList<String>();
        reservedGroupIds.add(COMMONS_GROUP_ID);
        reservedGroupIds.add(RENDERING_GROUP_ID);
        reservedGroupIds.add(PLATFORM_GROUP_ID);
        reservedGroupIds.add(ENTERPRISE_GROUP_ID);
        return reservedGroupIds;
    }

    private boolean isXWikiCoreCommitterExtension(Model model) {
        String groupId = model.getGroupId();
        return CORE_GROUP_IDS.contains(groupId);
    }

    private void checkNonCoreGroupId(Model model) throws EnforcerRuleException {
        String groupId = model.getGroupId();
        if (groupId.equals(CORE_GROUP_ID) || groupId.startsWith(CORE_GROUP_ID_PREFIX) && !groupId.equals(CONTRIB_GROUP_ID) && !groupId.startsWith(CONTRIB_GROUP_ID_PREFIX)) {
            throw new EnforcerRuleException(String.format("Contrib extension group id have to be prefixed with [%s]", CONTRIB_GROUP_ID));
        }
    }

    private void checkNonCoreArtifactId(Model model) throws EnforcerRuleException {
        String artifactId = model.getArtifactId();
        for (String prefix : CORE_ARTIFACT_ID_PREFIXES) {
            if (!artifactId.startsWith(prefix)) continue;
            throw new EnforcerRuleException("The [%s] artifact id prefix is reserved for XWiki Core Committers.");
        }
    }

    private void checkCoreArtifactId(Model model) throws EnforcerRuleException {
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        switch (groupId) {
            case "org.xwiki.commons": {
                this.checkArtifactId(groupId, artifactId, COMMONS_ARTIFACT_ID_PREFIX);
                break;
            }
            case "org.xwiki.rendering": {
                this.checkArtifactId(groupId, artifactId, RENDERING_ARTIFACT_ID_PREFIX);
                break;
            }
            case "org.xwiki.platform": {
                this.checkArtifactId(groupId, artifactId, PLATFORM_ARTIFACT_ID_PREFIX);
                break;
            }
            case "org.xwiki.enterprise": {
                this.checkArtifactId(groupId, artifactId, ENTERPRISE_ARTIFACT_ID_PREFIX);
                break;
            }
        }
    }

    private void checkArtifactId(String groupId, String artifactId, String prefix) throws EnforcerRuleException {
        if (!artifactId.startsWith(prefix)) {
            throw new EnforcerRuleException(String.format("Artifact Id must start with [%s] for group Id [%s] but found [%s]", prefix, groupId, artifactId));
        }
    }

    private void checkNonCoreDevelopers(Model model) throws EnforcerRuleException {
        List developers = model.getDevelopers();
        if (developers.size() == 1) {
            String developerName = ((Developer)developers.get(0)).getName();
            if (developerName == null) {
                throw new EnforcerRuleException("You must define <developers> section as otherwise your Extension will have no author");
            }
            if (developerName.equals(CORE_DEVELOPERS)) {
                throw new EnforcerRuleException(String.format("You must override the <developers> section as otherwise your Extension will be considered as developed by the [%s]", CORE_DEVELOPERS));
            }
        }
    }
}

