/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.enforcer;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;
import org.apache.maven.plugins.enforcer.BannedDependencies;

public class XWikiBannedDependencies
extends BannedDependencies {
    private static final String STAR = "*";

    protected boolean compareDependency(String pattern, Artifact artifact) throws EnforcerRuleException {
        String[] patternParts = pattern.split(":", 7);
        return this.compareDependency(patternParts, artifact);
    }

    private boolean compareDependency(String[] pattern, Artifact artifact) throws EnforcerRuleException {
        boolean result = false;
        if (pattern.length > 0) {
            result = artifact.getGroupId().matches(pattern[0]);
        }
        if (result && pattern.length > 1) {
            result = artifact.getArtifactId().matches(pattern[1]);
        }
        result = this.handleTwoPartsOrMore(result, pattern, artifact);
        result = this.handleThreePartsOrMore(result, pattern, artifact);
        result = this.handleFourPartsOrMore(result, pattern, artifact);
        return result;
    }

    private boolean handleTwoPartsOrMore(boolean result, String[] pattern, Artifact artifact) throws EnforcerRuleException {
        boolean newresult = result;
        if (result && pattern.length > 2) {
            if (STAR.equals(pattern[2]) || artifact.getVersion().equals(pattern[2])) {
                newresult = true;
            } else {
                try {
                    newresult = AbstractVersionEnforcer.containsVersion((VersionRange)VersionRange.createFromVersionSpec((String)pattern[2]), (ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new EnforcerRuleException("Invalid Version Range: ", (Exception)((Object)e));
                }
            }
        }
        return newresult;
    }

    private boolean handleThreePartsOrMore(boolean result, String[] pattern, Artifact artifact) {
        boolean newresult = result;
        if (result && pattern.length > 3) {
            String type = artifact.getType();
            if (type == null || type.equals("")) {
                type = "jar";
            }
            newresult = STAR.equals(pattern[3]) || type.equals(pattern[3]);
        }
        return newresult;
    }

    private boolean handleFourPartsOrMore(boolean result, String[] pattern, Artifact artifact) {
        boolean newresult = result;
        if (result && pattern.length > 4) {
            String scope = artifact.getScope();
            if (scope == null || scope.equals("")) {
                scope = "compile";
            }
            newresult = STAR.equals(pattern[4]) || scope.equals(pattern[4]);
        }
        return newresult;
    }
}

