/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.nio.file.Path;
import java.util.Objects;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.store.blob.BlobStore;
import org.xwiki.store.blob.BlobStoreException;
import org.xwiki.store.blob.BlobStoreFactory;
import org.xwiki.store.blob.BlobStorePropertiesBuilder;
import org.xwiki.store.blob.FileSystemBlobStoreProperties;
import org.xwiki.store.blob.internal.FileSystemBlobStore;

@Component
@Singleton
@Named(value="filesystem")
public class FileSystemBlobStoreFactory
implements BlobStoreFactory<FileSystemBlobStoreProperties> {
    @Inject
    private Environment environment;

    public String getType() {
        return "filesystem";
    }

    public BlobStorePropertiesBuilder newPropertiesBuilder(String name) throws BlobStoreException {
        Objects.requireNonNull(name, "Blob store name cannot be null");
        BlobStorePropertiesBuilder builder = new BlobStorePropertiesBuilder(name, this.getType());
        Path basePath = this.environment.getPermanentDirectory().toPath().resolve(name);
        builder.set("filesystem.rootDirectory", (Object)basePath);
        return builder;
    }

    public BlobStore create(String name, FileSystemBlobStoreProperties properties) throws BlobStoreException {
        return new FileSystemBlobStore(name, properties);
    }
}

