/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.store.blob.BlobAlreadyExistsException;
import org.xwiki.store.blob.BlobNotFoundException;
import org.xwiki.store.blob.BlobOption;
import org.xwiki.store.blob.BlobPath;
import org.xwiki.store.blob.BlobRangeOption;
import org.xwiki.store.blob.BlobStore;
import org.xwiki.store.blob.BlobStoreException;
import org.xwiki.store.blob.BlobWriteMode;
import org.xwiki.store.blob.internal.AbstractBlob;
import org.xwiki.store.blob.internal.BlobOptionSupport;
import org.xwiki.store.blob.internal.FileSystemBlobStore;

public class FileSystemBlob
extends AbstractBlob<FileSystemBlobStore> {
    private static final Set<Class<? extends BlobOption>> SUPPORTED_OUTPUT_OPTIONS = Set.of(BlobWriteMode.class);
    private static final Set<Class<? extends BlobOption>> SUPPORTED_INPUT_OPTIONS = Set.of(BlobRangeOption.class);
    private final Path absolutePath;

    public FileSystemBlob(BlobPath blobPath, Path absolutePath, FileSystemBlobStore store) {
        super((BlobStore)store, blobPath);
        this.absolutePath = absolutePath;
    }

    public boolean exists() {
        return Files.exists(this.absolutePath, LinkOption.NOFOLLOW_LINKS);
    }

    public long getSize() throws BlobStoreException {
        try {
            return Files.exists(this.absolutePath, LinkOption.NOFOLLOW_LINKS) ? Files.size(this.absolutePath) : -1L;
        }
        catch (IOException e) {
            throw new BlobStoreException("Error getting file size.", (Throwable)e);
        }
    }

    public OutputStream getOutputStream(BlobOption ... options) throws BlobStoreException {
        BlobOptionSupport.validateSupportedOptions(SUPPORTED_OUTPUT_OPTIONS, (BlobOption[])options);
        BlobWriteMode writeMode = (BlobWriteMode)BlobOptionSupport.findSingleOption(BlobWriteMode.class, (BlobOption[])options);
        NoSuchFileException lastNoSuchFileException = null;
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                ((FileSystemBlobStore)this.blobStore).createParents(this.absolutePath);
                if (writeMode == BlobWriteMode.CREATE_NEW) {
                    return Files.newOutputStream(this.absolutePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                return Files.newOutputStream(this.absolutePath, new OpenOption[0]);
            }
            catch (FileAlreadyExistsException e) {
                throw new BlobAlreadyExistsException(this.blobPath, (Throwable)e);
            }
            catch (NoSuchFileException e) {
                lastNoSuchFileException = e;
                continue;
            }
            catch (IOException e) {
                ((FileSystemBlobStore)this.blobStore).cleanUpParents(this.absolutePath);
                throw new BlobStoreException("Error getting output stream.", (Throwable)e);
            }
        }
        throw new BlobStoreException("Error creating parent directories for output stream in %s attempts.".formatted(5), (Throwable)lastNoSuchFileException);
    }

    public InputStream getStream(BlobOption ... options) throws BlobStoreException {
        BlobOptionSupport.validateSupportedOptions(SUPPORTED_INPUT_OPTIONS, (BlobOption[])options);
        BlobRangeOption rangeOption = (BlobRangeOption)BlobOptionSupport.findSingleOption(BlobRangeOption.class, (BlobOption[])options);
        try {
            if (rangeOption == null) {
                return Files.newInputStream(this.absolutePath, LinkOption.NOFOLLOW_LINKS);
            }
            return this.openRangeStream(rangeOption);
        }
        catch (NoSuchFileException e) {
            throw new BlobNotFoundException(this.blobPath, (Throwable)e);
        }
        catch (IOException e) {
            throw new BlobStoreException("Error getting input stream.", (Throwable)e);
        }
    }

    private InputStream openRangeStream(BlobRangeOption rangeOption) throws IOException {
        SeekableByteChannel channel = Files.newByteChannel(this.absolutePath, StandardOpenOption.READ);
        try {
            channel.position(rangeOption.getStartOffset());
            InputStream baseStream = Channels.newInputStream(channel);
            OptionalLong length = rangeOption.getLength();
            if (length.isEmpty()) {
                return baseStream;
            }
            return ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(baseStream)).setMaxCount(length.getAsLong())).get();
        }
        catch (IOException e) {
            channel.close();
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileSystemBlob)) {
            return false;
        }
        FileSystemBlob that = (FileSystemBlob)((Object)o);
        return new EqualsBuilder().append((Object)this.absolutePath, (Object)that.absolutePath).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.absolutePath).toHashCode();
    }
}

