/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob;

import java.util.Objects;
import java.util.OptionalLong;
import org.xwiki.stability.Unstable;
import org.xwiki.store.blob.BlobOption;

@Unstable
public final class BlobRangeOption
implements BlobOption {
    private final long startOffset;
    private final Long endOffset;

    private BlobRangeOption(long startOffset, Long endOffset) {
        if (startOffset < 0L) {
            throw new IllegalArgumentException("The start offset must be greater than or equal to zero.");
        }
        if (endOffset != null && endOffset < startOffset) {
            throw new IllegalArgumentException("The end offset must be greater than or equal to the start offset.");
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public static BlobRangeOption from(long startOffset) {
        return new BlobRangeOption(startOffset, null);
    }

    public static BlobRangeOption withLength(long startOffset, long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("The length must be greater than zero.");
        }
        try {
            long endOffset = Math.addExact(startOffset, length - 1L);
            return new BlobRangeOption(startOffset, endOffset);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("The requested range exceeds the maximum supported offset.", e);
        }
    }

    public static BlobRangeOption between(long startOffset, long endOffset) {
        return new BlobRangeOption(startOffset, endOffset);
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public OptionalLong getEndOffset() {
        return this.endOffset == null ? OptionalLong.empty() : OptionalLong.of(this.endOffset);
    }

    public OptionalLong getLength() {
        if (this.endOffset == null) {
            return OptionalLong.empty();
        }
        try {
            long difference = Math.subtractExact(this.endOffset, this.startOffset);
            return OptionalLong.of(Math.addExact(difference, 1L));
        }
        catch (ArithmeticException e) {
            return OptionalLong.empty();
        }
    }

    @Override
    public String getDescription() {
        if (this.endOffset == null) {
            return "Read from byte %d to the end".formatted(this.startOffset);
        }
        return "Read bytes %d to %d".formatted(this.startOffset, this.endOffset);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlobRangeOption)) {
            return false;
        }
        BlobRangeOption other = (BlobRangeOption)obj;
        return this.startOffset == other.startOffset && Objects.equals(this.endOffset, other.endOffset);
    }

    public int hashCode() {
        return Objects.hash(this.startOffset, this.endOffset);
    }
}

