/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.Failable;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.BeanManager;
import org.xwiki.store.blob.BlobPath;
import org.xwiki.store.blob.BlobStore;
import org.xwiki.store.blob.BlobStoreException;
import org.xwiki.store.blob.BlobStoreFactory;
import org.xwiki.store.blob.BlobStoreManager;
import org.xwiki.store.blob.BlobStoreProperties;
import org.xwiki.store.blob.BlobStorePropertiesBuilder;
import org.xwiki.store.blob.BlobStorePropertiesCustomizer;
import org.xwiki.store.blob.internal.BlobStoreConfiguration;
import org.xwiki.store.blob.internal.BlobStoreMigrator;

@Component
@Singleton
public class DefaultBlobStoreManager
implements BlobStoreManager,
Disposable {
    @Inject
    private BlobStoreConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Logger logger;
    @Inject
    private BlobStoreMigrator blobStoreMigrator;
    private final Map<String, BlobStore> blobStores = new ConcurrentHashMap<String, BlobStore>();

    @Override
    public BlobStore getBlobStore(String name) throws BlobStoreException {
        try {
            return this.blobStores.computeIfAbsent(name, key -> {
                try {
                    return this.getAndMaybeMigrateStore(name);
                }
                catch (ComponentLookupException | BlobStoreException e) {
                    throw Failable.rethrow((Throwable)e);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            Throwable throwable = e.getUndeclaredThrowable();
            if (throwable instanceof BlobStoreException) {
                BlobStoreException blobStoreException = (BlobStoreException)((Object)throwable);
                throw blobStoreException;
            }
            throw new BlobStoreException("Failed to get or create blob store with name [" + name + "]", e.getUndeclaredThrowable());
        }
    }

    private BlobStore getAndMaybeMigrateStore(String name) throws ComponentLookupException, BlobStoreException {
        String storeType = this.configuration.getStoreType();
        String migrationStoreType = this.configuration.getMigrationStoreType();
        BlobStore blobStore = this.getBlobStore(name, storeType);
        if (migrationStoreType != null && !migrationStoreType.equals(storeType)) {
            boolean needsMigration;
            boolean migrationInProgress = this.blobStoreMigrator.isMigrationInProgress(blobStore);
            boolean bl = needsMigration = migrationInProgress || !blobStore.hasDescendants(BlobPath.root());
            if (needsMigration) {
                BlobStore migrationStore = this.getBlobStore(name, migrationStoreType);
                this.blobStoreMigrator.migrate(blobStore, migrationStore);
            }
        }
        return blobStore;
    }

    private <T extends BlobStoreProperties> BlobStore getBlobStore(String name, String storeType) throws ComponentLookupException, BlobStoreException {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        BlobStoreFactory factory = (BlobStoreFactory)this.componentManager.getInstance(BlobStoreFactory.class, storeType);
        Type genericType = ReflectionUtils.resolveType(BlobStoreFactory.class, factory.getClass());
        if (genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            BlobStoreProperties properties;
            Class propertiesClass = (Class)typeArguments[0];
            BlobStorePropertiesBuilder propertiesBuilder = factory.newPropertiesBuilder(name);
            for (BlobStorePropertiesCustomizer customizer : this.componentManager.getInstanceList(BlobStorePropertiesCustomizer.class)) {
                customizer.customize(propertiesBuilder);
            }
            try {
                properties = (BlobStoreProperties)propertiesClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.beanManager.populate((Object)properties, propertiesBuilder.getAllProperties());
            }
            catch (Exception e) {
                throw new BlobStoreException("Failed to populate blob store properties for store [%s]".formatted(name), e);
            }
            return factory.create(name, properties);
        }
        throw new BlobStoreException("Failed to determine blob store properties type for store type [%s]".formatted(storeType));
    }

    public void dispose() throws ComponentLifecycleException {
        for (BlobStore blobStore : this.blobStores.values()) {
            if (!(blobStore instanceof Disposable)) continue;
            Disposable disposableStore = (Disposable)blobStore;
            try {
                disposableStore.dispose();
            }
            catch (Exception e) {
                this.logger.warn("Failed to dispose blob store [{}], root cause: [{}].", (Object)blobStore.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        this.blobStores.clear();
    }
}

