/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.xwiki.store.blob.Blob;
import org.xwiki.store.blob.BlobOption;
import org.xwiki.store.blob.BlobPath;
import org.xwiki.store.blob.BlobStore;
import org.xwiki.store.blob.BlobStoreException;
import org.xwiki.text.XWikiToStringBuilder;

public abstract class AbstractBlob<T extends BlobStore>
implements Blob {
    protected final T blobStore;
    protected final BlobPath blobPath;

    protected AbstractBlob(T store, BlobPath blobPath) {
        this.blobStore = store;
        this.blobPath = blobPath;
    }

    public T getStore() {
        return this.blobStore;
    }

    @Override
    public BlobPath getPath() {
        return this.blobPath;
    }

    @Override
    public void writeFromStream(InputStream inputStream, BlobOption ... options) throws BlobStoreException {
        try (OutputStream outputStream = this.getOutputStream(options);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BlobStoreException) {
                BlobStoreException blobStoreException = (BlobStoreException)((Object)throwable);
                throw blobStoreException;
            }
            throw new BlobStoreException("Error writing from InputStream to blob.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("blobStore", this.blobStore).append("blobPath", (Object)this.blobPath).toString();
    }
}

