/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob;

import org.xwiki.stability.Unstable;
import org.xwiki.store.blob.BlobOption;
import org.xwiki.store.blob.internal.BlobOptionSupport;

@Unstable
public enum BlobWriteMode implements BlobOption
{
    REPLACE_EXISTING("Replace existing blob"),
    CREATE_NEW("Create new blob only if absent");

    private final String description;

    private BlobWriteMode(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static BlobWriteMode resolve(BlobWriteMode defaultMode, BlobOption ... options) {
        BlobWriteMode explicitMode = BlobOptionSupport.findSingleOption(BlobWriteMode.class, options);
        return explicitMode != null ? explicitMode : defaultMode;
    }
}

