/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class ConvertUtilsConverter
implements Converter,
Initializable {
    public void initialize() {
        BeanUtilsBean.getInstance().getConvertUtils().register(true, false, 0);
    }

    private <T> T convert(Class<T> targetType, Object sourceValue) {
        Object result;
        try {
            result = ConvertUtils.convert((Object)sourceValue, targetType);
        }
        catch (org.apache.commons.beanutils.ConversionException ex) {
            throw new ConversionException("Error while performing type conversion", ex);
        }
        if (result == null) {
            return null;
        }
        if (!TypeUtils.isAssignable(targetType, result.getClass())) {
            throw new ConversionException(String.format("Failed to find a Converter to convert from [%s] to [%s]", sourceValue.getClass().getName(), targetType.getName()));
        }
        return (T)result;
    }

    public Object convert(Type targetType, Object sourceValue) {
        Class clazz;
        if (targetType instanceof Class) {
            clazz = (Class)targetType;
        } else if (targetType instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)targetType).getRawType();
        } else {
            throw new ConversionException("Unknown type [" + targetType + "]");
        }
        return this.convert(clazz, sourceValue);
    }
}

