/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.properties.PropertyGroupDescriptor;
import org.xwiki.properties.annotation.PropertyAdvanced;
import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyDisplayHidden;
import org.xwiki.properties.annotation.PropertyDisplayType;
import org.xwiki.properties.annotation.PropertyFeature;
import org.xwiki.properties.annotation.PropertyGroup;
import org.xwiki.properties.annotation.PropertyHidden;
import org.xwiki.properties.annotation.PropertyId;
import org.xwiki.properties.annotation.PropertyMandatory;
import org.xwiki.properties.annotation.PropertyName;
import org.xwiki.properties.internal.DefaultPropertyDescriptor;

public class DefaultBeanDescriptor
implements BeanDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBeanDescriptor.class);
    private static final List<Class<? extends Annotation>> COMMON_ANNOTATION_CLASSES = Arrays.asList(PropertyMandatory.class, Deprecated.class, PropertyAdvanced.class, PropertyGroup.class, PropertyFeature.class, PropertyDisplayType.class, PropertyDisplayHidden.class);
    private Class<?> beanClass;
    private Map<String, PropertyDescriptor> parameterDescriptorMap = new LinkedHashMap<String, PropertyDescriptor>();
    private Map<PropertyGroup, PropertyGroupDescriptor> groups = new HashMap<PropertyGroup, PropertyGroupDescriptor>();

    public DefaultBeanDescriptor(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.extractBeanDescriptor();
    }

    protected void extractBeanDescriptor() {
        Object defaultInstance = null;
        Constructor constructor = ConstructorUtils.getAccessibleConstructor(this.getBeanClass(), (Class[])new Class[0]);
        if (constructor != null) {
            try {
                defaultInstance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to create a new default instance for class [{}]. The BeanDescriptor will not contains any default value information.", (Object)this.getBeanClass().getName(), (Object)e);
            }
        }
        try {
            for (Class<?> currentClass = this.getBeanClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] fields = currentClass.getFields();
                for (Field field : fields) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    this.extractPropertyDescriptor(field, defaultInstance);
                }
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getBeanClass());
            java.beans.PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (java.beans.PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (propertyDescriptor == null) continue;
                    this.extractPropertyDescriptor(propertyDescriptor, defaultInstance);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load bean descriptor for class [{}]. Ignoring it. Root cause: [{}]", (Object)this.getBeanClass().getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    protected void extractPropertyDescriptor(java.beans.PropertyDescriptor propertyDescriptor, Object defaultInstance) {
        Method readMethod;
        PropertyHidden parameterHidden;
        DefaultPropertyDescriptor desc = new DefaultPropertyDescriptor();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod != null && (parameterHidden = this.extractPropertyAnnotation(writeMethod, readMethod = propertyDescriptor.getReadMethod(), PropertyHidden.class)) == null) {
            PropertyId propertyId = this.extractPropertyAnnotation(writeMethod, readMethod, PropertyId.class);
            desc.setId(propertyId != null ? propertyId.value() : propertyDescriptor.getName());
            Type propertyType = readMethod != null ? readMethod.getGenericReturnType() : writeMethod.getGenericParameterTypes()[0];
            desc.setPropertyType(propertyType);
            PropertyName parameterName = this.extractPropertyAnnotation(writeMethod, readMethod, PropertyName.class);
            desc.setName(parameterName != null ? parameterName.value() : desc.getId());
            PropertyDescription parameterDescription = this.extractPropertyAnnotation(writeMethod, readMethod, PropertyDescription.class);
            desc.setDescription(parameterDescription != null ? parameterDescription.value() : propertyDescriptor.getShortDescription());
            HashMap<Class, Annotation> annotations = new HashMap<Class, Annotation>();
            COMMON_ANNOTATION_CLASSES.forEach(aClass -> annotations.put((Class)aClass, (Annotation)this.extractPropertyAnnotation(writeMethod, readMethod, (Class)aClass)));
            this.setCommonProperties(desc, annotations);
            if (defaultInstance != null && readMethod != null) {
                try {
                    desc.setDefaultValue(readMethod.invoke(defaultInstance, new Object[0]));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get default property value from getter [{}] in class [{}]. Ignoring it. Root cause [{}]", new Object[]{readMethod.getName(), this.getBeanClass(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                }
            }
            desc.setWriteMethod(writeMethod);
            desc.setReadMethod(readMethod);
            this.parameterDescriptorMap.put(desc.getId(), desc);
        }
    }

    protected void extractPropertyDescriptor(Field field, Object defaultInstance) {
        DefaultPropertyDescriptor desc = new DefaultPropertyDescriptor();
        PropertyHidden parameterHidden = field.getAnnotation(PropertyHidden.class);
        if (parameterHidden == null) {
            PropertyId propertyId = field.getAnnotation(PropertyId.class);
            desc.setId(propertyId != null ? propertyId.value() : field.getName());
            desc.setPropertyType(field.getGenericType());
            PropertyName parameterName = field.getAnnotation(PropertyName.class);
            desc.setName(parameterName != null ? parameterName.value() : desc.getId());
            PropertyDescription parameterDescription = field.getAnnotation(PropertyDescription.class);
            desc.setDescription(parameterDescription != null ? parameterDescription.value() : desc.getId());
            HashMap<Class, Annotation> annotations = new HashMap<Class, Annotation>();
            COMMON_ANNOTATION_CLASSES.forEach(aClass -> annotations.put((Class)aClass, (Annotation)field.getAnnotation(aClass)));
            this.setCommonProperties(desc, annotations);
            if (defaultInstance != null) {
                try {
                    desc.setDefaultValue(field.get(defaultInstance));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get default property value from field [{}] in class [{}]. Ignoring it. Root cause: [{}]", new Object[]{field.getName(), this.getBeanClass(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                }
            }
            desc.setField(field);
            this.parameterDescriptorMap.put(desc.getId(), desc);
        }
    }

    private void setCommonProperties(DefaultPropertyDescriptor desc, Map<Class, Annotation> annotations) {
        desc.setMandatory(annotations.get(PropertyMandatory.class) != null);
        desc.setDeprecated(annotations.get(Deprecated.class) != null);
        desc.setAdvanced(annotations.get(PropertyAdvanced.class) != null);
        this.handlePropertyFeatureAndGroupAnnotations(desc, annotations);
        this.handlePropertyDisplayTypeAnnotation(desc, annotations);
        desc.setDisplayHidden(annotations.get(PropertyDisplayHidden.class) != null);
    }

    private void handlePropertyFeatureAndGroupAnnotations(DefaultPropertyDescriptor desc, Map<Class, Annotation> annotations) {
        PropertyFeature parameterFeature;
        PropertyGroup parameterGroup = (PropertyGroup)annotations.get(PropertyGroup.class);
        PropertyGroupDescriptor group = this.groups.get(parameterGroup);
        if (group == null && parameterGroup != null) {
            group = new PropertyGroupDescriptor(Arrays.asList(parameterGroup.value()));
        } else if (group == null) {
            group = new PropertyGroupDescriptor(null);
        }
        desc.setGroupDescriptor(group);
        if (parameterGroup != null) {
            this.groups.put(parameterGroup, group);
        }
        if ((parameterFeature = (PropertyFeature)annotations.get(PropertyFeature.class)) != null) {
            if (group.getFeature() != null) {
                throw new RuntimeException(String.format("Property [%s] has overridden a feature (previous: [%s], new: [%s])", desc.getId(), group.getFeature(), parameterFeature.value()));
            }
            group.setFeature(parameterFeature.value());
        }
    }

    private void handlePropertyDisplayTypeAnnotation(DefaultPropertyDescriptor desc, Map<Class, Annotation> annotations) {
        Object[] types;
        PropertyDisplayType displayTypeAnnotation = (PropertyDisplayType)annotations.get(PropertyDisplayType.class);
        Object displayType = displayTypeAnnotation != null && displayTypeAnnotation.value().length > 0 ? ((types = displayTypeAnnotation.value()).length > 1 ? new DefaultParameterizedType(null, types[0], (Type[])ArrayUtils.remove((Object[])types, (int)0)) : types[0]) : desc.getPropertyType();
        desc.setDisplayType((Type)displayType);
    }

    protected <T extends Annotation> T extractPropertyAnnotation(Method writeMethod, Method readMethod, Class<T> annotationClass) {
        T parameterDescription = writeMethod.getAnnotation(annotationClass);
        if (parameterDescription == null && readMethod != null) {
            parameterDescription = readMethod.getAnnotation(annotationClass);
        }
        return parameterDescription;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Collection<PropertyDescriptor> getProperties() {
        return this.parameterDescriptorMap.values();
    }

    @Override
    public PropertyDescriptor getProperty(String propertyName) {
        return this.parameterDescriptorMap.get(propertyName);
    }
}

