/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.stability.Unstable;

public abstract class AbstractEventListener
implements EventListener {
    private final String name;
    private final List<Event> events;

    public AbstractEventListener(String name, List<? extends Event> events) {
        this.name = name;
        this.events = events;
    }

    public AbstractEventListener(String name, Event ... events) {
        this.name = name;
        this.events = Arrays.asList(events);
    }

    @Unstable
    public AbstractEventListener(String name, Object ... values) {
        this.name = name;
        this.events = new ArrayList<Event>();
        for (Object value : values) {
            if (value instanceof Event) {
                this.events.add((Event)value);
                continue;
            }
            if (value instanceof Iterable) {
                ((Iterable)value).forEach(this.events::add);
                continue;
            }
            if (!(value instanceof Event[])) continue;
            for (Event event : (Event[])value) {
                this.events.add(event);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }
}

