/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.AbstractBot;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.ChannelStore;
import org.xwiki.netflux.internal.MessageDispatcher;
import org.xwiki.netflux.internal.User;

@Component
@Singleton
@Named(value="HistoryKeeper")
public class HistoryKeeper
extends AbstractBot {
    @Inject
    private Logger logger;
    @Inject
    private ChannelStore channels;
    @Inject
    private MessageDispatcher dispatcher;

    @Override
    public String getId() {
        return super.getId().substring(0, 16);
    }

    @Override
    public void onUserMessage(User sender, List<Object> message) {
        List<Object> messageBody;
        if (message.size() <= 3) {
            return;
        }
        try {
            messageBody = this.dispatcher.decode(message.get(3).toString());
        }
        catch (Exception e) {
            this.logger.debug("Failed to parse message body.", (Throwable)e);
            return;
        }
        if (messageBody.size() < 2 || !"GET_HISTORY".equals(messageBody.get(0))) {
            return;
        }
        String channelKey = (String)messageBody.get(1);
        Channel channel = this.channels.get(channelKey);
        if (channel != null) {
            channel.getMessages().forEach(msgStr -> this.dispatcher.addMessage(sender, (String)msgStr));
        }
        String endHistoryBody = "{\"state\":1, \"channel\":\"" + channelKey + "\"}";
        String endHistoryMessage = this.dispatcher.buildMessage(0, this.getId(), sender.getName(), endHistoryBody);
        this.dispatcher.addMessage(sender, endHistoryMessage);
    }

    @Override
    public void onChannelMessage(Channel channel, User sender, String messageType, String message) {
        if ("MSG".equals(messageType)) {
            this.logger.debug("Added in history: [{}]", (Object)message);
            if (this.isCheckpoint(message)) {
                this.logger.debug("Pruning old messages.");
                LinkedList<String> recentMessages = new LinkedList<String>();
                Iterator<String> iterator = channel.getMessages().descendingIterator();
                while (iterator.hasNext()) {
                    String recentMessage = iterator.next();
                    recentMessages.addFirst(recentMessage);
                    if (!this.isCheckpoint(recentMessage)) continue;
                    break;
                }
                channel.getMessages().clear();
                channel.getMessages().addAll(recentMessages);
            }
            channel.getMessages().add(message);
        }
    }

    private boolean isCheckpoint(String message) {
        Object lastItem;
        List<Object> msg = this.dispatcher.decode(message);
        if (!msg.isEmpty() && (lastItem = msg.get(msg.size() - 1)) instanceof String) {
            String s = (String)lastItem;
            return s.startsWith("cp|[4,[");
        }
        return false;
    }
}

