/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.netflux.internal.Bot;
import org.xwiki.netflux.internal.User;

public class Channel {
    private final String key;
    private final long creationDate = System.currentTimeMillis();
    private final Map<String, User> users = new LinkedHashMap<String, User>();
    private final Map<String, Bot> bots = new LinkedHashMap<String, Bot>();
    private final Deque<String> messages = new LinkedList<String>();

    public Channel(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public Map<String, Bot> getBots() {
        return this.bots;
    }

    public List<User> getConnectedUsers() {
        return this.users.values().stream().filter(user -> user.getSession() != null && user.isConnected()).toList();
    }

    public Deque<String> getMessages() {
        return this.messages;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append(this.creationDate).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Channel otherChannel = (Channel)object;
        return new EqualsBuilder().append((Object)this.key, (Object)otherChannel.key).append(this.creationDate, otherChannel.creationDate).isEquals();
    }
}

