/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.websocket.DecodeException;
import jakarta.websocket.EncodeException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.JsonConverter;

@Component(roles={MessageBuilder.class})
@Singleton
public class MessageBuilder {
    public static final String COMMAND_MSG = "MSG";
    @Inject
    protected Logger logger;
    private final JsonConverter converter = new JsonConverter();

    public String buildMessage(Integer sequence, String senderId, String receiverId, Object messageBody) {
        return this.encode(List.of(sequence, senderId, COMMAND_MSG, receiverId, messageBody));
    }

    public String buildAck(Integer sequence) {
        return this.encode(List.of(sequence, "ACK"));
    }

    public String buildJoinAck(Integer sequence, String channelKey) {
        return this.encode(List.of(sequence, "JACK", channelKey));
    }

    public String buildDefault(String senderId, String messageType, String receiverId, Object messageBody) {
        ArrayList<Object> msg = new ArrayList<Object>();
        msg.add(0);
        msg.add(senderId);
        msg.add(messageType);
        msg.add(receiverId);
        if (messageBody != null) {
            msg.add(messageBody);
        }
        return this.encode(msg);
    }

    public String buildError(Integer sequence, String errorType, String errorMessage) {
        return this.encode(List.of(sequence, "ERROR", errorType, errorMessage));
    }

    public String encode(List<Object> message) {
        try {
            return this.converter.encode(message);
        }
        catch (EncodeException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> decode(String message) {
        try {
            return this.converter.decode(message);
        }
        catch (DecodeException e) {
            throw new RuntimeException(e);
        }
    }
}

