/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.Bot;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.IdGenerator;

@Component(roles={ChannelStore.class})
@Singleton
public class ChannelStore {
    @Inject
    private Provider<List<Bot>> botsProvider;
    @Inject
    private IdGenerator idGenerator;
    private final Map<String, Channel> channelByKey = new ConcurrentHashMap<String, Channel>();

    public Channel create() {
        Channel channel = new Channel(this.idGenerator.generateChannelId());
        this.askBotsToJoin(channel);
        this.channelByKey.put(channel.getKey(), channel);
        return channel;
    }

    public void askBotsToJoin(Channel channel) {
        ((List)this.botsProvider.get()).stream().filter(bot -> !channel.getBots().containsKey(bot.getId())).filter(bot -> bot.onJoinChannel(channel)).forEach(bot -> channel.getBots().put(bot.getId(), (Bot)bot));
    }

    public Channel get(String key) {
        return this.channelByKey.get(key);
    }

    public boolean remove(Channel channel) {
        channel.getBots().values().forEach(bot -> bot.onLeaveChannel(channel));
        return this.channelByKey.remove(channel.getKey()) != null;
    }

    public void prune() {
        try {
            long currentTime = System.currentTimeMillis();
            for (Channel channel : this.channelByKey.values()) {
                if (!channel.getConnectedUsers().isEmpty() || currentTime - channel.getCreationDate() <= 0x6DDD00L) continue;
                this.remove(channel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

