/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.Bot;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.ChannelStore;
import org.xwiki.netflux.internal.IdGenerator;
import org.xwiki.netflux.internal.MessageBuilder;
import org.xwiki.netflux.internal.User;
import org.xwiki.websocket.AbstractPartialStringMessageHandler;
import org.xwiki.websocket.EndpointComponent;

@Component
@Singleton
@Named(value="netflux")
public class NetfluxEndpoint
extends Endpoint
implements EndpointComponent {
    private static final long TIMEOUT_MILLISECONDS = 65000L;
    private static final String NETFLUX_USER = "netflux.user";
    private static final String COMMAND_LEAVE = "LEAVE";
    private static final String COMMAND_JOIN = "JOIN";
    private static final String ERROR_INVALID = "EINVAL";
    private static final String ERROR_NO_ENTITY = "ENOENT";
    private final Object bigLock = new Object();
    private final Map<String, User> users = new HashMap<String, User>();
    @Inject
    private Logger logger;
    @Inject
    private IdGenerator idGenerator;
    @Inject
    private ChannelStore channels;
    @Inject
    private MessageBuilder messageBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(final Session session, EndpointConfig config) {
        Object object = this.bigLock;
        synchronized (object) {
            session.setMaxIdleTimeout(65000L);
            User user = this.getOrRegisterUser(session);
            String identMessage = this.messageBuilder.buildDefault("", "IDENT", user.getName(), null);
            if (!this.sendMessage(user, identMessage)) {
                return;
            }
            session.addMessageHandler((MessageHandler)new AbstractPartialStringMessageHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(String message) {
                    Object object = NetfluxEndpoint.this.bigLock;
                    synchronized (object) {
                        NetfluxEndpoint.this.onMessage(session, message);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        Object object = this.bigLock;
        synchronized (object) {
            User user = this.getOrRegisterUser(session);
            this.logger.debug("Last message from [{}] received [{}ms] ago. Session idle timeout is [{}].", new Object[]{user.getName(), System.currentTimeMillis() - user.getTimeOfLastMessage(), session.getMaxIdleTimeout()});
            this.logger.debug("Disconnecting [{}] because [{}] ([{}])", new Object[]{user.getName(), closeReason.getReasonPhrase(), closeReason.getCloseCode()});
            this.users.remove(user.getName());
            user.setConnected(false);
            new LinkedList<Channel>(user.getChannels()).forEach(channel -> this.leaveChannel(user, (Channel)channel, "Disconnected"));
        }
    }

    public void onError(Session session, Throwable e) {
        this.logger.debug("Session closed with error.", e);
        this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ExceptionUtils.getRootCauseMessage((Throwable)e)));
    }

    private User getOrRegisterUser(Session session) {
        User user = (User)session.getUserProperties().get(NETFLUX_USER);
        if (user == null) {
            String userId = this.idGenerator.generateUserId();
            user = new User(session, userId);
            this.users.put(userId, user);
            session.getUserProperties().put(NETFLUX_USER, user);
            this.logger.debug("Registered [{}]", (Object)userId);
        }
        return user;
    }

    private void onMessage(Session session, String message) {
        List<Object> msg = this.messageBuilder.decode(message);
        if (msg == null) {
            return;
        }
        User user = this.getOrRegisterUser(session);
        user.setTimeOfLastMessage(System.currentTimeMillis());
        Integer seq = (Integer)msg.get(0);
        String cmd = msg.get(1).toString();
        String obj = "";
        if (msg.size() >= 3) {
            obj = Objects.toString(msg.get(2), null);
        }
        if (COMMAND_JOIN.equals(cmd)) {
            this.onCommandJoin(user, seq, obj);
        } else if (COMMAND_LEAVE.equals(cmd)) {
            this.onCommandLeave(user, seq, obj);
        } else if (cmd.equals("PING")) {
            this.onCommandPing(user, seq);
        } else if ("MSG".equals(cmd)) {
            this.onCommandMessage(user, seq, obj, msg);
        }
    }

    private void onCommandJoin(User user, Integer seq, String channelKey) {
        Channel channel;
        if (!StringUtils.isEmpty((CharSequence)channelKey) && channelKey.length() != 48) {
            String errorMsg = this.messageBuilder.buildError(seq, ERROR_INVALID, "Invalid channel key");
            this.sendMessage(user, errorMsg);
            return;
        }
        Channel channel2 = channel = channelKey == null ? null : this.channels.get(channelKey);
        if (channel == null && StringUtils.isEmpty((CharSequence)channelKey)) {
            channel = this.channels.create();
        } else if (channel == null) {
            String errorMsg = this.messageBuilder.buildError(seq, ERROR_NO_ENTITY, String.format("Channel [%s] not found", channelKey));
            this.sendMessage(user, errorMsg);
            return;
        }
        String jackMsg = this.messageBuilder.buildJoinAck(seq, channel.getKey());
        this.sendMessage(user, jackMsg);
        user.getChannels().add(channel);
        LinkedHashSet<String> botsAndUsers = new LinkedHashSet<String>(channel.getBots().keySet());
        botsAndUsers.addAll(channel.getUsers().keySet());
        for (String userOrBotId : botsAndUsers) {
            String inChannelMsg = this.messageBuilder.buildDefault(userOrBotId, COMMAND_JOIN, channel.getKey(), null);
            this.sendMessage(user, inChannelMsg);
        }
        channel.getUsers().put(user.getName(), user);
        this.channels.prune();
        String joinMsg = this.messageBuilder.buildDefault(user.getName(), COMMAND_JOIN, channel.getKey(), null);
        this.sendChannelMessage(COMMAND_JOIN, user, channel, joinMsg);
    }

    private void onCommandLeave(User user, Integer seq, String channelKey) {
        String errorMsg = null;
        if (StringUtils.isEmpty((CharSequence)channelKey)) {
            errorMsg = this.messageBuilder.buildError(seq, ERROR_INVALID, "Channel key is not specified");
        } else if (this.channels.get(channelKey) == null) {
            errorMsg = this.messageBuilder.buildError(seq, ERROR_NO_ENTITY, channelKey);
        } else if (!this.channels.get(channelKey).getUsers().containsKey(user.getName())) {
            errorMsg = this.messageBuilder.buildError(seq, "NOT_IN_CHAN", channelKey);
        }
        if (errorMsg != null) {
            this.sendMessage(user, errorMsg);
            return;
        }
        String ackMsg = this.messageBuilder.buildAck(seq);
        this.sendMessage(user, ackMsg);
        Channel channel = this.channels.get(channelKey);
        this.leaveChannel(user, channel, "");
    }

    private void leaveChannel(User user, Channel channel, String reason) {
        channel.getUsers().remove(user.getName());
        user.getChannels().remove(channel);
        String leaveMessage = this.messageBuilder.buildDefault(user.getName(), COMMAND_LEAVE, channel.getKey(), reason);
        this.sendChannelMessage(COMMAND_LEAVE, user, channel, leaveMessage);
        if (channel.getConnectedUsers().isEmpty()) {
            this.channels.remove(channel);
        }
    }

    private void onCommandPing(User user, Integer seq) {
        String ackMsg = this.messageBuilder.buildAck(seq);
        this.sendMessage(user, ackMsg);
    }

    private void onCommandMessage(User user, Integer seq, String channelKeyOrUserName, List<Object> msg) {
        String ackMsg = this.messageBuilder.buildAck(seq);
        this.sendMessage(user, ackMsg);
        Optional<Bot> bot = this.getBot(user, channelKeyOrUserName);
        if (bot.isPresent()) {
            bot.get().onUserMessage(user, msg);
        } else if (this.channels.get(channelKeyOrUserName) != null) {
            String msgMsg = this.messageBuilder.buildMessage(0, user.getName(), channelKeyOrUserName, msg.get(3));
            Channel chan = this.channels.get(channelKeyOrUserName);
            this.sendChannelMessage("MSG", user, chan, msgMsg);
        } else if (this.users.containsKey(channelKeyOrUserName)) {
            String msgMsg = this.messageBuilder.buildMessage(0, user.getName(), channelKeyOrUserName, msg.get(3));
            this.sendMessage(this.users.get(channelKeyOrUserName), msgMsg);
        } else if (!channelKeyOrUserName.isEmpty()) {
            String errorMsg = this.messageBuilder.buildError(seq, ERROR_NO_ENTITY, channelKeyOrUserName);
            this.sendMessage(user, errorMsg);
        }
    }

    private Optional<Bot> getBot(User user, String id) {
        return user.getChannels().stream().map(channel -> channel.getBots().get(id)).filter(Objects::nonNull).findFirst();
    }

    private boolean sendMessage(User user, String message) {
        try {
            this.logger.debug("Sending to [{}] : [{}]", (Object)user.getName(), (Object)message);
            user.getSession().getBasicRemote().sendText(message);
            return true;
        }
        catch (IOException e) {
            this.logger.debug("Sending failed.", (Throwable)e);
            this.onClose(user.getSession(), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ExceptionUtils.getRootCauseMessage((Throwable)e)));
            return false;
        }
    }

    private void sendChannelMessage(String cmd, User me, Channel channel, String message) {
        channel.getBots().values().forEach(bot -> bot.onChannelMessage(channel, me, cmd, message));
        channel.getUsers().values().stream().filter(user -> !"MSG".equals(cmd) || !user.equals(me)).forEach(user -> this.sendMessage((User)user, message));
    }
}

