/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xwiki.netflux.internal.User;
import org.xwiki.netflux.internal.Utils;

public class Channel {
    private final String key = Utils.getRandomHexString(48);
    private final long creationDate = System.currentTimeMillis();
    private final Map<String, User> users = new LinkedHashMap<String, User>();
    private final LinkedList<String> messages = new LinkedList();

    public String getKey() {
        return this.key;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public List<User> getConnectedUsers() {
        return this.users.values().stream().filter(user -> user != null && user.getSession() != null && user.isConnected()).collect(Collectors.toList());
    }

    public LinkedList<String> getMessages() {
        return this.messages;
    }
}

