/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.EncodeException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.ChannelStore;
import org.xwiki.netflux.internal.HistoryKeeper;
import org.xwiki.netflux.internal.JsonConverter;
import org.xwiki.netflux.internal.SendJob;
import org.xwiki.netflux.internal.User;
import org.xwiki.netflux.internal.Utils;
import org.xwiki.websocket.EndpointComponent;

@Component
@Singleton
@Named(value="netflux")
public class NetfluxEndpoint
extends Endpoint
implements EndpointComponent {
    private static final long TIMEOUT_MILLISECONDS = 30000L;
    private static final String NETFLUX_USER = "netflux.user";
    private static final String COMMAND_LEAVE = "LEAVE";
    private static final String COMMAND_JOIN = "JOIN";
    private static final String COMMAND_MSG = "MSG";
    private static final String ERROR_INVALID = "EINVAL";
    private static final String ERROR_NO_ENTITY = "ENOENT";
    private final Object bigLock = new Object();
    private final Map<String, User> users = new HashMap<String, User>();
    private final JsonConverter converter = new JsonConverter();
    @Inject
    private Logger logger;
    @Inject
    private ChannelStore channels;
    @Inject
    private HistoryKeeper historyKeeper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(final Session session, EndpointConfig config) {
        Object object = this.bigLock;
        synchronized (object) {
            User user = this.getOrRegisterUser(session);
            String identMessage = this.display(this.buildDefault("", "IDENT", user.getName(), null));
            if (!this.sendMessage(user, identMessage)) {
                return;
            }
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    NetfluxEndpoint.this.handleMessage(session, message);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        Object object = this.bigLock;
        synchronized (object) {
            this.wsDisconnect(session);
        }
    }

    public void onError(Session session, Throwable e) {
        this.logger.debug("Session closed with error.", e);
        this.onClose(session, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Session session, String message) {
        SendJob sendJob;
        Iterator<String> iterator = this.bigLock;
        synchronized (iterator) {
            this.onMessage(session, message);
            sendJob = this.getSendJob();
        }
        while (sendJob != null) {
            for (String msg : sendJob.getMessages()) {
                if (!sendJob.getUser().isConnected()) break;
                if (this.sendMessage(sendJob.getUser(), msg)) continue;
                return;
            }
            sendJob = this.getSendJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wsDisconnect(Session session) {
        Object object = this.bigLock;
        synchronized (object) {
            User user = this.getOrRegisterUser(session);
            this.logger.debug("Disconnect " + user.getName());
            this.users.remove(user.getName());
            user.setConnected(false);
            for (Channel channel : user.getChannels()) {
                channel.getUsers().remove(user.getName());
                ArrayList<Object> leaveMessage = this.buildDefault(user.getName(), COMMAND_LEAVE, channel.getKey(), "Quit: [ wsDisconnect() ]");
                String msgStr = this.display(leaveMessage);
                this.sendChannelMessage(COMMAND_LEAVE, user, channel, msgStr);
                if (!channel.getConnectedUsers().isEmpty()) continue;
                this.channels.remove(channel);
            }
        }
    }

    private User getOrRegisterUser(Session session) {
        User user = (User)session.getUserProperties().get(NETFLUX_USER);
        if (user == null) {
            String userName = Utils.getRandomHexString(32);
            user = new User(session, userName);
            this.users.put(userName, user);
            session.getUserProperties().put(NETFLUX_USER, user);
            this.logger.debug("Registered " + userName);
        }
        return user;
    }

    private void onMessage(Session session, String message) {
        Object msg;
        try {
            msg = this.converter.decode(message);
        }
        catch (DecodeException e) {
            throw new RuntimeException(e);
        }
        if (msg == null) {
            return;
        }
        User user = this.getOrRegisterUser(session);
        long now = System.currentTimeMillis();
        user.setTimeOfLastMessage(now);
        List sessions = this.users.values().stream().map(User::getSession).collect(Collectors.toList());
        sessions.stream().filter(s -> now - this.getOrRegisterUser((Session)s).getTimeOfLastMessage() > 30000L).forEach(this::wsDisconnect);
        Integer seq = (Integer)msg.get(0);
        String cmd = msg.get(1).toString();
        String obj = "";
        if (msg.size() >= 3) {
            obj = Objects.toString(msg.get(2), null);
        }
        if (COMMAND_JOIN.equals(cmd)) {
            this.onCommandJoin(user, seq, obj);
        } else if (COMMAND_LEAVE.equals(cmd)) {
            this.onCommandLeave(user, seq, obj);
        } else if (cmd.equals("PING")) {
            this.onCommandPing(user, seq);
        } else if (COMMAND_MSG.equals(cmd)) {
            this.onCommandMessage(user, seq, obj, (List<Object>)msg);
        }
    }

    private void onCommandJoin(User user, Integer seq, String channelKey) {
        Channel channel;
        if (!StringUtils.isEmpty((CharSequence)channelKey) && channelKey.length() != 32 && channelKey.length() != 48) {
            ArrayList<Object> errorMsg = this.buildError(seq, ERROR_INVALID, "");
            this.addMessage(user, this.display(errorMsg));
            return;
        }
        Channel channel2 = channel = channelKey == null ? null : this.channels.get(channelKey);
        if (channel == null && StringUtils.isEmpty((CharSequence)channelKey)) {
            channel = this.channels.create();
        } else if (channel == null) {
            ArrayList<Object> errorMsg = this.buildError(seq, ERROR_NO_ENTITY, "");
            this.addMessage(user, this.display(errorMsg));
            return;
        }
        ArrayList<Object> jackMsg = this.buildJack(seq, channel.getKey());
        this.addMessage(user, this.display(jackMsg));
        user.getChannels().add(channel);
        for (String userId : channel.getUsers().keySet()) {
            ArrayList<Object> inChannelMsg = this.buildDefault(userId, COMMAND_JOIN, channel.getKey(), null);
            this.addMessage(user, this.display(inChannelMsg));
        }
        channel.getUsers().put(user.getName(), user);
        this.channels.prune();
        ArrayList<Object> joinMsg = this.buildDefault(user.getName(), COMMAND_JOIN, channel.getKey(), null);
        this.sendChannelMessage(COMMAND_JOIN, user, channel, this.display(joinMsg));
    }

    private void onCommandLeave(User user, Integer seq, String channelKey) {
        ArrayList<Object> errorMsg = null;
        if (StringUtils.isEmpty((CharSequence)channelKey)) {
            errorMsg = this.buildError(seq, ERROR_INVALID, "undefined");
        }
        if (errorMsg != null && this.channels.get(channelKey) == null) {
            errorMsg = this.buildError(seq, ERROR_NO_ENTITY, channelKey);
        }
        if (errorMsg != null && !this.channels.get(channelKey).getUsers().containsKey(user.getName())) {
            errorMsg = this.buildError(seq, "NOT_IN_CHAN", channelKey);
        }
        if (errorMsg != null) {
            this.addMessage(user, this.display(errorMsg));
            return;
        }
        ArrayList<Object> ackMsg = this.buildAck(seq);
        this.addMessage(user, this.display(ackMsg));
        Channel channel = this.channels.get(channelKey);
        channel.getUsers().remove(user.getName());
        user.getChannels().remove(channel);
        ArrayList<Object> leaveMsg = this.buildDefault(user.getName(), COMMAND_LEAVE, channelKey, "");
        this.sendChannelMessage(COMMAND_LEAVE, user, channel, this.display(leaveMsg));
    }

    private void onCommandPing(User user, Integer seq) {
        ArrayList<Object> ackMsg = this.buildAck(seq);
        this.addMessage(user, this.display(ackMsg));
    }

    private void onCommandMessage(User user, Integer seq, String channelKeyOrUserName, List<Object> msg) {
        ArrayList<Object> ackMsg = this.buildAck(seq);
        this.addMessage(user, this.display(ackMsg));
        String historyKeeperKey = this.historyKeeper.getKey();
        if (historyKeeperKey != null && channelKeyOrUserName.equals(historyKeeperKey)) {
            String text;
            Object msgHistory;
            try {
                msgHistory = this.converter.decode(msg.get(3).toString());
            }
            catch (DecodeException e) {
                msgHistory = null;
                this.logger.debug("Failed to parse message history.", (Throwable)e);
            }
            String string = text = msgHistory == null ? "" : (String)msgHistory.get(0);
            if ("GET_HISTORY".equals(text)) {
                String channelKey = (String)msgHistory.get(1);
                Channel channel = this.channels.get(channelKey);
                if (channel != null) {
                    channel.getMessages().forEach(msgStr -> this.addMessage(user, (String)msgStr));
                }
                String endHistoryMsg = "{\"state\":1, \"channel\":\"" + channelKey + "\"}";
                ArrayList<Object> msgEndHistory = this.buildMessage(0, historyKeeperKey, user.getName(), endHistoryMsg);
                this.addMessage(user, this.display(msgEndHistory));
            }
        } else if (this.channels.get(channelKeyOrUserName) != null) {
            ArrayList<Object> msgMsg = this.buildMessage(0, user.getName(), channelKeyOrUserName, msg.get(3));
            Channel chan = this.channels.get(channelKeyOrUserName);
            this.sendChannelMessage(COMMAND_MSG, user, chan, this.display(msgMsg));
        } else if (this.users.containsKey(channelKeyOrUserName)) {
            ArrayList<Object> msgMsg = this.buildMessage(0, user.getName(), channelKeyOrUserName, msg.get(3));
            this.addMessage(this.users.get(channelKeyOrUserName), this.display(msgMsg));
        } else if (!channelKeyOrUserName.isEmpty()) {
            ArrayList<Object> errorMsg = this.buildError(seq, ERROR_NO_ENTITY, channelKeyOrUserName);
            this.addMessage(user, this.display(errorMsg));
        }
    }

    private boolean sendMessage(User user, String message) {
        try {
            this.logger.debug("Sending to [{}] : [{}]", (Object)user.getName(), (Object)message);
            user.getSession().getBasicRemote().sendText(message);
            return true;
        }
        catch (IOException e) {
            this.logger.debug("Sending failed.", (Throwable)e);
            this.wsDisconnect(user.getSession());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendJob getSendJob() {
        Object object = this.bigLock;
        synchronized (object) {
            for (User user : this.users.values()) {
                if (!user.isConnected() || user.getMessagesToBeSent().isEmpty()) continue;
                SendJob out = new SendJob(user, new ArrayList<String>(user.getMessagesToBeSent()));
                user.getMessagesToBeSent().clear();
                return out;
            }
            return null;
        }
    }

    private String display(List<Object> list) {
        try {
            return this.converter.encode(list);
        }
        catch (EncodeException e) {
            throw new RuntimeException(e);
        }
    }

    private void addMessage(User toUser, String message) {
        this.logger.debug("Adding message to [{}]: [{}]", (Object)toUser.getName(), (Object)message);
        toUser.getMessagesToBeSent().add(message);
    }

    private boolean isCheckpoint(String message) {
        try {
            Object msg = this.converter.decode(message);
            return ((String)msg.get(msg.size() - 1)).indexOf("cp|[4,[") == 0;
        }
        catch (DecodeException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendChannelMessage(String cmd, User me, Channel channel, String message) {
        channel.getUsers().values().stream().filter(Objects::nonNull).filter(user -> !COMMAND_MSG.equals(cmd) || !user.equals(me)).forEach(user -> this.addMessage((User)user, message));
        if (this.historyKeeper.getKey() != null && (COMMAND_MSG.equals(cmd) || COMMAND_LEAVE.equals(cmd))) {
            this.logger.debug("Added in history: [{}]", (Object)message);
            if (COMMAND_MSG.equals(cmd) && this.isCheckpoint(message)) {
                this.logger.debug("Pruning old messages.");
                LinkedList<String> msgsNext = new LinkedList<String>();
                Iterator<String> it = channel.getMessages().descendingIterator();
                while (it.hasNext()) {
                    String msg = it.next();
                    msgsNext.addFirst(msg);
                    if (!this.isCheckpoint(msg)) continue;
                    break;
                }
                channel.getMessages().clear();
                channel.getMessages().addAll(msgsNext);
            }
            channel.getMessages().add(message);
        }
    }

    private ArrayList<Object> buildAck(Integer seq) {
        ArrayList<Object> msg = new ArrayList<Object>();
        msg.add(seq);
        msg.add("ACK");
        return msg;
    }

    private ArrayList<Object> buildJack(Integer seq, String obj) {
        ArrayList<Object> msg = new ArrayList<Object>();
        msg.add(seq);
        msg.add("JACK");
        msg.add(obj);
        return msg;
    }

    private ArrayList<Object> buildDefault(String userId, String cmd, String chanName, String reason) {
        ArrayList<Object> msg = new ArrayList<Object>();
        msg.add(0);
        msg.add(userId);
        msg.add(cmd);
        msg.add(chanName);
        if (reason != null) {
            msg.add(reason);
        }
        return msg;
    }

    private ArrayList<Object> buildMessage(Integer seq, String userId, String obj, Object msgStr) {
        ArrayList<Object> msg = new ArrayList<Object>();
        msg.add(0);
        msg.add(userId);
        msg.add(COMMAND_MSG);
        msg.add(obj);
        msg.add(msgStr);
        return msg;
    }

    private ArrayList<Object> buildError(Integer seq, String errorType, String errorMessage) {
        ArrayList<Object> msg = new ArrayList<Object>();
        msg.add(seq);
        msg.add("ERROR");
        msg.add(errorType);
        msg.add(errorMessage);
        return msg;
    }
}

