/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.HistoryKeeper;

@Component(roles={ChannelStore.class})
@Singleton
public class ChannelStore {
    @Inject
    private HistoryKeeper historyKeeper;
    private final Map<String, Channel> channelByKey = new ConcurrentHashMap<String, Channel>();

    public Channel create() {
        Channel channel = new Channel();
        String historyKeeperKey = this.historyKeeper.getKey();
        if (historyKeeperKey != null) {
            channel.getUsers().put(historyKeeperKey, null);
        }
        this.channelByKey.put(channel.getKey(), channel);
        return channel;
    }

    public Channel get(String key) {
        return this.channelByKey.get(key);
    }

    public boolean remove(Channel channel) {
        return this.channelByKey.remove(channel.getKey()) != null;
    }

    public void prune() {
        try {
            long currentTime = System.currentTimeMillis();
            for (Channel channel : this.channelByKey.values()) {
                if (!channel.getConnectedUsers().isEmpty() || currentTime - channel.getCreationDate() <= 0x6DDD00L) continue;
                this.remove(channel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

