/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.logback.internal.LogbackUtils;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="LogbackEventGenerator")
public class LogbackEventGenerator
extends AppenderBase<ILoggingEvent>
implements EventListener,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;

    public String getName() {
        return "LogbackEventGenerator";
    }

    public List<Event> getEvents() {
        return Collections.emptyList();
    }

    public void initialize() throws InitializationException {
        ch.qos.logback.classic.Logger rootLogger = LogbackUtils.getRootLogger();
        this.setContext((Context)rootLogger.getLoggerContext());
        rootLogger.addAppender((Appender)this);
        this.start();
    }

    public void onEvent(Event event, Object source, Object data) {
    }

    private ObservationManager getObservationManager() throws ComponentLookupException {
        return (ObservationManager)this.componentManager.lookup(ObservationManager.class);
    }

    protected void append(ILoggingEvent event) {
        Throwable throwable = null;
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy instanceof ThrowableProxy) {
            throwable = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        try {
            LogLevel logLevel = LogLevel.valueOf((String)event.getLevel().toString());
            LogEvent logevent = new LogEvent(logLevel, event.getMessage(), event.getArgumentArray(), throwable);
            this.getObservationManager().notify((Event)logevent, (Object)event.getLoggerName(), null);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Unsupported log level [{}]", (Object)event.getLevel());
        }
        catch (ComponentLookupException e) {
            this.logger.error("Can't find any implementation of [{}]", (Object)ObservationManager.class.getName(), (Object)e);
        }
    }
}

