/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import java.util.Iterator;
import java.util.Stack;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.logback.internal.ForbiddenThreadsFilter;
import org.xwiki.logging.logback.internal.LogbackEventGenerator;
import org.xwiki.logging.logback.internal.LogbackUtils;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.WrappedThreadEventListener;

@Component
public class DefaultLoggerManager
implements LoggerManager,
Initializable {
    @Inject
    private ObservationManager observation;
    private ThreadLocal<Stack<EventListener>> listeners = new ThreadLocal();
    private ForbiddenThreadsFilter forbiddenThreads = new ForbiddenThreadsFilter();

    public void initialize() throws InitializationException {
        Logger rootLogger = LogbackUtils.getRootLogger();
        Iterator iterator = rootLogger.iteratorForAppenders();
        while (iterator.hasNext()) {
            Appender appender = (Appender)iterator.next();
            if (appender instanceof LogbackEventGenerator) continue;
            appender.addFilter((Filter)this.forbiddenThreads);
        }
    }

    public void pushLogListener(EventListener listener) {
        Stack<Object> listenerStack = this.listeners.get();
        if (listenerStack == null) {
            listenerStack = new Stack();
            this.listeners.set(listenerStack);
        }
        if (!listenerStack.isEmpty()) {
            this.observation.removeListener(((EventListener)listenerStack.peek()).getName());
        }
        this.observation.addListener((EventListener)new WrappedThreadEventListener(listener, Thread.currentThread()));
        if (listenerStack.isEmpty()) {
            this.grabLog(Thread.currentThread());
        }
        listenerStack.push(listener);
    }

    public EventListener popLogListener() {
        EventListener listener;
        Stack<EventListener> listenerStack = this.listeners.get();
        if (listenerStack != null && !listenerStack.isEmpty()) {
            listener = listenerStack.pop();
            this.observation.removeListener(listener.getName());
            if (listenerStack.isEmpty()) {
                this.ungrabLog(Thread.currentThread());
            }
        } else {
            listener = null;
        }
        return listener;
    }

    private void grabLog(Thread thread) {
        this.forbiddenThreads.addThread(thread);
    }

    private void ungrabLog(Thread thread) {
        this.forbiddenThreads.removeThread(thread);
    }
}

