/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.helpers;

import java.util.ArrayList;
import java.util.List;

public final class ExtendedMessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    private ExtendedMessageFormatter() {
    }

    public static List<String> parseMessage(String messagePattern, Object[] arguments) {
        if (messagePattern == null) {
            return null;
        }
        if (arguments == null) {
            return null;
        }
        ArrayList<String> messageList = new ArrayList<String>(arguments.length + 1);
        int i = 0;
        for (int argumentsIndex = 0; argumentsIndex < arguments.length; ++argumentsIndex) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    messageList.add(messagePattern);
                    return messageList;
                }
                messageList.add(messagePattern.substring(i, messagePattern.length()));
                return messageList;
            }
            if (ExtendedMessageFormatter.isEscapedDelimeter(messagePattern, j)) {
                if (!ExtendedMessageFormatter.isDoubleEscaped(messagePattern, j)) {
                    --argumentsIndex;
                    String str = messagePattern.substring(i, j - 1) + '{';
                    if (messageList.isEmpty()) {
                        messageList.add(str);
                    } else {
                        messageList.set(messageList.size() - 1, (String)messageList.get(messageList.size() - 1) + str);
                    }
                    i = j + 1;
                    continue;
                }
                messageList.add(messagePattern.substring(i, j - 1));
                i = j + 2;
                continue;
            }
            messageList.add(messagePattern.substring(i, j));
            i = j + 2;
        }
        messageList.add(messagePattern.substring(i, messagePattern.length()));
        return messageList;
    }

    static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        return messagePattern.charAt(delimeterStartIndex - 1) == '\\';
    }
}

