/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.lang.reflect.Type;
import org.xwiki.component.util.ReflectionUtils;

public class RoleHint<T> {
    public static final String DEFAULT_HINT = "default";
    private Type role;
    private String hint;

    public RoleHint(Type role) {
        this(role, null);
    }

    public RoleHint(Type role, String hint) {
        this.role = role;
        this.hint = hint;
        if (this.hint == null) {
            this.hint = DEFAULT_HINT;
        }
    }

    public Type getRoleType() {
        return this.role;
    }

    public Class<T> getRoleClass() {
        return ReflectionUtils.getTypeClass((Type)this.role);
    }

    public String getHint() {
        return this.hint;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RoleHint rolehint = (RoleHint)obj;
        return this.getRoleType().equals(rolehint.getRoleType()) && (this.getHint() == rolehint.getHint() || this.getHint() != null && this.getHint().equals(rolehint.getHint()));
    }

    public int hashCode() {
        int hash = 8;
        hash = 31 * hash + (null == this.getRoleType() ? 0 : this.getRoleType().hashCode());
        hash = 31 * hash + (null == this.getHint() ? 0 : this.getHint().hashCode());
        return hash;
    }

    public String toString() {
        return "role = [" + String.valueOf(this.getRoleType()) + "] hint = [" + this.getHint() + "]";
    }
}

