/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.descriptor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentRole;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ObjectUtils;
import org.xwiki.component.util.ReflectionUtils;

public class DefaultComponentDependency<T>
extends DefaultComponentRole<T>
implements ComponentDependency<T> {
    private String name;
    private String[] hints;

    public DefaultComponentDependency() {
    }

    public DefaultComponentDependency(ComponentDependency<T> dependency) {
        super(dependency);
        this.setName(dependency.getName());
        if (dependency.getHints() != null) {
            this.setHints((String[])dependency.getHints().clone());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getHints() {
        return this.hints;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHints(String[] hints) {
        this.hints = hints;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = this == object ? true : (object == null || object.getClass() != this.getClass() ? false : this.equals((ComponentDependency)object));
        return result;
    }

    private boolean equals(ComponentDependency dependency) {
        return super.equals(dependency) && ObjectUtils.equals(this.getName(), dependency.getName()) && Arrays.equals(this.getHints(), dependency.getHints());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + ObjectUtils.hasCode(this.getRoleType());
        hash = 31 * hash + ObjectUtils.hasCode(this.getName());
        hash = 31 * hash + Arrays.hashCode(this.getHints());
        return hash;
    }

    @Override
    @Deprecated
    public Class<?> getMappingType() {
        return ReflectionUtils.getTypeClass(this.getRoleType());
    }

    @Deprecated
    public void setMappingType(Class<?> mappingType) {
        if (this.getRoleType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.getRoleType();
            Type ownerType = parameterizedType.getOwnerType();
            Type[] parameters = parameterizedType.getActualTypeArguments();
            this.setRoleType(new DefaultParameterizedType(ownerType, mappingType, parameters));
        } else {
            this.setRoleType(mappingType);
        }
    }

    @Override
    public Class<T> getRole() {
        Class<?> mapping = this.getMappingType();
        if (mapping == List.class || mapping == Collection.class || mapping == Map.class || mapping == Provider.class) {
            return ReflectionUtils.getTypeClass(ReflectionUtils.getLastTypeGenericArgument(this.getRoleType()));
        }
        return mapping;
    }

    @Override
    public void setRole(Class<T> role) {
        Class mapping = this.getMappingType();
        if (mapping == List.class || mapping == Collection.class || mapping == Map.class || mapping == Provider.class) {
            Class rawType;
            Type ownerType;
            if (this.getRoleType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)this.getRoleType();
                ownerType = parameterizedType.getOwnerType();
                rawType = (Class)parameterizedType.getRawType();
            } else {
                ownerType = null;
                rawType = mapping;
            }
            this.setRoleType(new DefaultParameterizedType(ownerType, rawType, role));
        } else {
            super.setRole(role);
        }
    }
}

