/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.event.status.QuestionAnsweredEvent;
import org.xwiki.job.event.status.QuestionAskedEvent;
import org.xwiki.job.internal.DefaultJobProgress;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.Logger;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LoggerListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.WrappedThreadEventListener;
import org.xwiki.observation.event.Event;

public abstract class AbstractJobStatus<R extends Request>
implements JobStatus {
    private final transient ObservationManager observationManager;
    private final transient LoggerManager loggerManager;
    private final transient ReentrantLock askLock = new ReentrantLock();
    private final transient Condition answered = this.askLock.newCondition();
    private final transient JobStatus parentJobStatus;
    private final DefaultJobProgress progress = new DefaultJobProgress();
    private final LogQueue logs;
    private transient LoggerListener logListener;
    private volatile transient Object question;
    private String jobType;
    private JobStatus.State state = JobStatus.State.NONE;
    private Throwable error;
    private R request;
    private Date startDate;
    private Date endDate;
    private boolean isolated = true;
    private boolean canceled;

    @Deprecated
    public AbstractJobStatus(R request, JobStatus parentJobStatus, ObservationManager observationManager, LoggerManager loggerManager) {
        this(null, request, parentJobStatus, observationManager, loggerManager);
    }

    public AbstractJobStatus(String jobType, R request, JobStatus parentJobStatus, ObservationManager observationManager, LoggerManager loggerManager) {
        this.jobType = jobType;
        this.request = request;
        this.parentJobStatus = parentJobStatus;
        this.isolated = parentJobStatus == null;
        this.observationManager = observationManager;
        this.loggerManager = loggerManager;
        this.logs = new LogQueue();
    }

    public void startListening() {
        this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.progress));
        this.logListener = new LoggerListener(LoggerListener.class.getName() + '_' + this.hashCode(), (Logger)this.logs);
        if (this.isIsolated()) {
            this.loggerManager.pushLogListener((EventListener)this.logListener);
        } else {
            this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.logListener));
        }
    }

    public void stopListening() {
        if (this.isIsolated()) {
            this.loggerManager.popLogListener();
        } else {
            this.observationManager.removeListener(this.logListener.getName());
        }
        this.observationManager.removeListener(this.progress.getName());
        this.progress.getRootStep().finish();
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    public void setState(JobStatus.State state) {
        this.state = state;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public R getRequest() {
        return this.request;
    }

    @Override
    public LogQueue getLog() {
        return this.logs != null ? this.logs : new LogQueue();
    }

    @Override
    public JobProgress getProgress() {
        return this.progress;
    }

    @Override
    public void ask(Object question) throws InterruptedException {
        this.ask(question, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ask(Object question, long time, TimeUnit unit) throws InterruptedException {
        boolean notTimeout = true;
        this.question = question;
        this.askLock.lockInterruptibly();
        try {
            this.state = JobStatus.State.WAITING;
            if (this.isSubJob()) {
                this.parentJobStatus.ask(question);
            } else {
                String questionType = question != null ? question.getClass().getName() : null;
                QuestionAskedEvent event = new QuestionAskedEvent(questionType, this.request.getId());
                this.observationManager.notify((Event)event, (Object)this);
                if (event.isAnswered()) {
                    this.answered();
                } else if (unit != null) {
                    notTimeout = this.answered.await(time, unit);
                } else {
                    this.answered.await();
                }
            }
            this.state = JobStatus.State.RUNNING;
        }
        finally {
            this.askLock.unlock();
        }
        return notTimeout;
    }

    @Override
    public Object getQuestion() {
        return this.question;
    }

    @Override
    public void answered() {
        this.askLock.lock();
        try {
            if (this.isSubJob()) {
                this.question = null;
                this.parentJobStatus.answered();
            } else {
                String questionType = this.question != null ? this.question.getClass().getName() : null;
                this.observationManager.notify((Event)new QuestionAnsweredEvent(questionType, this.request.getId()), (Object)this);
                this.question = null;
                this.answered.signal();
            }
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isSubJob() {
        return this.getParentJobStatus() != null;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public JobStatus getParentJobStatus() {
        return this.parentJobStatus;
    }

    @Override
    @Deprecated
    public List<LogEvent> getLog(LogLevel level) {
        return this.getLog().getLogs(level);
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

