/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.AbstractJobStatus;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.marker.BeginTranslationMarker;
import org.xwiki.logging.marker.EndTranslationMarker;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractJob<R extends Request, S extends AbstractJobStatus<? super R>>
implements Job {
    private static final BeginTranslationMarker LOG_BEGIN = new BeginTranslationMarker("job.log.begin");
    private static final BeginTranslationMarker LOG_BEGIN_ID = new BeginTranslationMarker("job.log.beginWithId");
    private static final EndTranslationMarker LOG_END = new EndTranslationMarker("job.log.end");
    private static final EndTranslationMarker LOG_END_ID = new EndTranslationMarker("job.log.endWithId");
    private static final TranslationMarker LOG_EXCEPTION = new TranslationMarker("job.log.exception");
    private static final TranslationMarker LOG_STATUS_STORE_FAILED = new TranslationMarker("job.log.status.store.failed");
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected ObservationManager observationManager;
    @Inject
    protected LoggerManager loggerManager;
    @Inject
    protected JobStatusStore store;
    @Inject
    private Provider<Execution> executionProvider;
    @Inject
    private Provider<ExecutionContextManager> executionContextManagerProvider;
    @Inject
    protected Logger logger;
    @Inject
    protected JobContext jobContext;
    @Inject
    protected JobProgressManager progressManager;
    protected R request;
    protected S status;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition finishedCondition = this.lock.newCondition();
    protected boolean initExecutionContext = true;

    public R getRequest() {
        return this.request;
    }

    public S getStatus() {
        return this.status;
    }

    @Override
    public void initialize(Request request) {
        this.request = this.castRequest(request);
        this.status = this.createNewStatus(this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.initExecutionContext) {
            Execution execution = (Execution)this.executionProvider.get();
            ExecutionContext context = execution.getContext() == null ? new ExecutionContext() : null;
            try {
                if (context != null) {
                    try {
                        ((ExecutionContextManager)this.executionContextManagerProvider.get()).initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize Job [" + this + "] execution context", e);
                    }
                }
                this.runInContext();
            }
            finally {
                if (context != null) {
                    execution.removeContext();
                }
            }
        }
        this.runInContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInContext() {
        Throwable error = null;
        try {
            this.jobStarting();
            this.runInternal();
            this.jobFinished(error);
        }
        catch (Throwable t) {
            try {
                this.logger.error((Marker)LOG_EXCEPTION, "Exception thrown during job execution", t);
                error = t;
                this.jobFinished(error);
            }
            catch (Throwable throwable) {
                this.jobFinished(error);
                throw throwable;
            }
        }
    }

    @Override
    @Deprecated
    public void start(Request request) {
        this.initialize(request);
        this.run();
    }

    protected void jobStarting() {
        this.jobContext.pushCurrentJob(this);
        this.observationManager.notify((Event)new JobStartedEvent(this.getRequest().getId(), this.getType(), (Request)this.request), (Object)this);
        ((AbstractJobStatus)this.status).setStartDate(new Date());
        ((AbstractJobStatus)this.status).setState(JobStatus.State.RUNNING);
        ((AbstractJobStatus)this.status).startListening();
        if (((AbstractJobStatus)this.getStatus()).getRequest().getId() != null) {
            this.logger.info((Marker)LOG_BEGIN_ID, "Starting job of type [{}] with identifier [{}]", (Object)this.getType(), ((AbstractJobStatus)this.getStatus()).getRequest().getId());
        } else {
            this.logger.info((Marker)LOG_BEGIN, "Starting job of type [{}]", (Object)this.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobFinished(Throwable exception) {
        this.lock.lock();
        try {
            this.observationManager.notify((Event)new JobFinishedEvent(this.getRequest().getId(), this.getType(), (Request)this.request), (Object)this, (Object)exception);
            ((AbstractJobStatus)this.status).setEndDate(new Date());
            if (((AbstractJobStatus)this.getStatus()).getRequest().getId() != null) {
                this.logger.info((Marker)LOG_END_ID, "Finished job of type [{}] with identifier [{}]", (Object)this.getType(), ((AbstractJobStatus)this.getStatus()).getRequest().getId());
            } else {
                this.logger.info((Marker)LOG_END, "Finished job of type [{}]", (Object)this.getType());
            }
            ((AbstractJobStatus)this.status).stopListening();
            ((AbstractJobStatus)this.status).setState(JobStatus.State.FINISHED);
            this.finishedCondition.signalAll();
            this.jobContext.popCurrentJob();
            try {
                if (this.request.getId() != null) {
                    this.store.storeAsync((JobStatus)this.status);
                }
            }
            catch (Throwable t) {
                this.logger.warn((Marker)LOG_STATUS_STORE_FAILED, "Failed to store job status [{}]", this.status, (Object)t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected R castRequest(Request request) {
        return (R)request;
    }

    protected S createNewStatus(R request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        return (S)new DefaultJobStatus<R>(request, this.observationManager, this.loggerManager, currentJobStatus);
    }

    @Deprecated
    protected void notifyPushLevelProgress(int steps) {
        this.progressManager.pushLevelProgress(steps, this);
    }

    @Deprecated
    protected void notifyStepPropress() {
        this.progressManager.stepPropress(this);
    }

    @Deprecated
    protected void notifyPopLevelProgress() {
        this.progressManager.popLevelProgress(this);
    }

    protected abstract void runInternal() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.getStatus() == null || ((AbstractJobStatus)this.getStatus()).getState() != JobStatus.State.FINISHED) {
                this.finishedCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (((AbstractJobStatus)this.getStatus()).getState() != JobStatus.State.FINISHED) {
                boolean bl = this.finishedCondition.await(time, unit);
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }
}

