/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.annotation.Serializable;

public final class XStreamUtils {
    private static final List<Class<?>> UNSERIALIZABLE_CLASSES = Arrays.asList(Logger.class, Provider.class, ComponentManager.class, OutputStream.class, InputStream.class);

    private XStreamUtils() {
    }

    public static boolean isSafeType(Object obj) {
        return obj == null || obj instanceof String || obj instanceof Number || obj.getClass().isArray() || obj instanceof Enum;
    }

    public static boolean isSerializable(Object item) {
        return item == null || XStreamUtils.isSerializable(item.getClass());
    }

    public static boolean isSerializable(Field field) {
        return XStreamUtils.isSerializable(field.getType());
    }

    public static boolean isSerializable(Class<?> itemClass) {
        Serializable serializable = itemClass.getAnnotation(Serializable.class);
        if (serializable != null) {
            return serializable.value();
        }
        if (java.io.Serializable.class.isAssignableFrom(itemClass)) {
            return true;
        }
        if (itemClass.isAnnotationPresent(Component.class)) {
            return false;
        }
        for (Class<?> clazz : UNSERIALIZABLE_CLASSES) {
            if (!clazz.isAssignableFrom(itemClass)) continue;
            return false;
        }
        return true;
    }

    public static void serializeField(String name, Class<?> defaultType, Object value, HierarchicalStreamWriter writer, MarshallingContext context, Mapper mapper) {
        if (value != null) {
            writer.startNode(name);
            Class<?> actualType = value.getClass();
            if (actualType != defaultType) {
                String serializedClassName = mapper.serializedClass(actualType);
                String attributeName = mapper.aliasForSystemAttribute("class");
                if (attributeName != null) {
                    writer.addAttribute(attributeName, serializedClassName);
                }
            }
            context.convertAnother(value);
            writer.endNode();
        }
    }
}

