/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.event;

import java.util.List;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobEvent;

abstract class AbstractJobEvent
implements JobEvent {
    private static final long serialVersionUID = 1L;
    private Request request;
    private List<String> jobId;
    private String jobType;

    AbstractJobEvent() {
    }

    protected AbstractJobEvent(String jobType) {
        this.jobType = jobType;
    }

    protected AbstractJobEvent(List<String> jobId, String jobType, Request request) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.request = request;
    }

    @Override
    public List<String> getJobId() {
        return this.jobId;
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public boolean matches(Object event) {
        return this.getClass() == event.getClass() && this.matchesJobId((JobEvent)event) && this.matchesJobType((JobEvent)event);
    }

    private boolean matchesJobId(JobEvent event) {
        return this.jobId == null || this.jobId.equals(event.getJobId());
    }

    private boolean matchesJobType(JobEvent event) {
        return this.jobType == null || this.jobType.equals(event.getJobType());
    }
}

