/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.xwiki.job.internal.xstream.SafeArrayConverter;
import org.xwiki.job.internal.xstream.SafeLogEventConverter;
import org.xwiki.job.internal.xstream.SafeMessageConverter;
import org.xwiki.job.internal.xstream.SafeReflectionProvider;
import org.xwiki.job.internal.xstream.SafeThrowableConverter;
import org.xwiki.job.internal.xstream.SafeTreeMarshallingStrategy;

public class SafeXStream
extends XStream {
    private MarshallingStrategy marshallingStrategy;

    public SafeXStream() {
        super((ReflectionProvider)new SafeReflectionProvider(JVM.newReflectionProvider()));
        this.registerConverter((Converter)new SafeArrayConverter(this));
        this.registerConverter((Converter)new SafeMessageConverter(this));
        this.registerConverter((Converter)new SafeLogEventConverter(this));
        this.registerConverter(new SafeThrowableConverter(this.getMapper(), this.getConverterLookup().lookupConverterForType(Object.class)));
        this.ignoreUnknownElements();
        this.setMarshallingStrategy((MarshallingStrategy)new SafeTreeMarshallingStrategy());
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        super.setMarshallingStrategy(marshallingStrategy);
        this.marshallingStrategy = marshallingStrategy;
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        try {
            return this.marshallingStrategy.unmarshal(root, reader, dataHolder, this.getConverterLookup(), this.getMapper());
        }
        catch (ConversionException e) {
            Package pkg = ((Object)((Object)this)).getClass().getPackage();
            String version = pkg != null ? pkg.getImplementationVersion() : null;
            e.add("version", version != null ? version : "not available");
            throw e;
        }
    }
}

