/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.job.internal.xstream.SafeWriter;
import org.xwiki.job.internal.xstream.XStreamUtils;

public class SafeTreeMarshaller
extends ReferenceByXPathMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTreeMarshaller.class);
    protected SafeWriter safeWriter;

    public SafeTreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper, int mode) {
        super(writer, converterLookup, mapper, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(Object item, Converter converter) {
        if (XStreamUtils.isSerializable(item)) {
            HierarchicalStreamWriter currentWriter = this.writer;
            try {
                this.safeWriter = new SafeWriter(this.writer);
                this.writer = this.safeWriter;
                super.convert(item, converter);
            }
            catch (Throwable e) {
                LOGGER.debug("Failed to serialize item [{}]", (Object)(item.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(item))), (Object)e);
                this.safeWriter.fix();
            }
            finally {
                this.writer = currentWriter;
            }
        }
    }
}

