/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Marker;
import org.xwiki.job.annotation.Serializable;
import org.xwiki.job.internal.xstream.SafeArrayConverter;
import org.xwiki.job.internal.xstream.SafeXStream;
import org.xwiki.job.internal.xstream.XStreamUtils;
import org.xwiki.logging.Message;

public class SafeMessageConverter
extends SafeArrayConverter {
    protected static final String FIELD_MESSAGE = "message";
    protected static final String FIELD_MARKER = "marker";
    protected static final String FIELD_ARGUMENTARRAY = "argumentArray";
    protected static final String FIELD_THROWABLE = "throwable";

    public SafeMessageConverter(SafeXStream xstream) {
        super(xstream);
    }

    @Override
    public boolean canConvert(Class type) {
        return type == Message.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Message message = (Message)source;
        XStreamUtils.serializeField(FIELD_MESSAGE, String.class, message.getMessage(), writer, context, this.mapper());
        XStreamUtils.serializeField(FIELD_MARKER, Marker.class, message.getMarker(), writer, context, this.mapper());
        if (message.getArgumentArray() != null) {
            writer.startNode(FIELD_ARGUMENTARRAY);
            for (Object argument : message.getArgumentArray()) {
                if (this.isSerializable(argument)) {
                    this.writeCompleteItem(argument, context, writer);
                    continue;
                }
                this.writeCompleteItem(argument.toString(), context, writer);
            }
            writer.endNode();
        }
        XStreamUtils.serializeField(FIELD_THROWABLE, Throwable.class, message.getThrowable(), writer, context, this.mapper());
    }

    protected boolean isSerializable(Object argument) {
        if (argument == null) {
            return true;
        }
        Serializable serializable = argument.getClass().getAnnotation(Serializable.class);
        if (serializable != null) {
            return serializable.value();
        }
        return argument instanceof java.io.Serializable;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Marker marker = null;
        String message = "";
        List<Object> arguments = Collections.emptyList();
        Throwable throwable = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "marker": {
                    marker = this.read(Marker.class, reader, context);
                    break;
                }
                case "message": {
                    message = reader.getValue();
                    break;
                }
                case "throwable": {
                    throwable = this.read(Throwable.class, reader, context);
                    break;
                }
                case "argumentArray": {
                    arguments = this.unmarshalArgumentArray(reader, context);
                    break;
                }
            }
            reader.moveUp();
        }
        return new Message(marker, message, arguments.toArray(), throwable);
    }

    protected List<Object> unmarshalArgumentArray(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object argument = this.readBareItem(reader, context, null);
            arguments.add(argument);
            reader.moveUp();
        }
        return arguments;
    }

    protected <T> T read(Class<T> defaultType, HierarchicalStreamReader reader, UnmarshallingContext context) {
        String classAttribute = HierarchicalStreams.readClassAttribute((HierarchicalStreamReader)reader, (Mapper)this.mapper());
        return (T)context.convertAnother(null, classAttribute != null ? this.mapper().realClass(classAttribute) : defaultType);
    }
}

