/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.job.internal.xstream.SafeXStream;
import org.xwiki.job.internal.xstream.XStreamUtils;

public class SafeArrayConverter
extends ArrayConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeArrayConverter.class);

    public SafeArrayConverter(SafeXStream xstream) {
        super(xstream.getMapper());
    }

    public boolean canConvert(Class type) {
        return type == Object[].class;
    }

    protected Object readBareItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        Object value;
        try {
            value = super.readBareItem(reader, context, current);
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to read field", e);
            value = null;
        }
        return value;
    }

    protected void writeCompleteItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        if (XStreamUtils.isSerializable(item)) {
            super.writeCompleteItem(item, context, writer);
        } else {
            String str;
            try {
                str = item.toString();
            }
            catch (Throwable e) {
                LOGGER.debug("Failed to convert item [{}] to String", (Object)(item.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(item))), (Object)e);
                str = null;
            }
            super.writeCompleteItem((Object)str, context, writer);
        }
    }
}

