/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.xstream.SafeXStream;

public class JobStatusSerializer {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private XStream xstream = new SafeXStream();

    public void write(JobStatus status, File file) throws IOException {
        File tempFile = File.createTempFile(file.getName(), ".tmp");
        try (FileOutputStream stream = FileUtils.openOutputStream((File)tempFile);){
            this.write(status, stream);
        }
        file.mkdirs();
        for (int i = 0; i < 10; ++i) {
            try {
                Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            catch (FileAlreadyExistsException e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ei) {
                    throw e;
                }
            }
        }
    }

    public void write(JobStatus status, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, DEFAULT_ENCODING);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.xstream.toXML((Object)status, (Writer)writer);
        writer.flush();
    }

    public JobStatus read(File file) {
        return (JobStatus)this.xstream.fromXML(file);
    }

    public JobStatus read(InputStream stream) {
        return (JobStatus)this.xstream.fromXML(stream);
    }
}

