/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.job.Request;

public abstract class AbstractRequest
implements Request {
    private static final long serialVersionUID = 1L;
    private List<String> id;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean verbose = true;
    private Boolean statusLogIsolated;
    private Boolean statusSerialized;

    public AbstractRequest() {
    }

    public AbstractRequest(Request request) {
        this.setId(request.getId());
        for (String key : request.getPropertyNames()) {
            this.setProperty(key, request.getProperty(key));
        }
    }

    @Override
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id != null ? new ArrayList<String>(id) : null;
    }

    public void setId(String id) {
        this.setId(Arrays.asList(id));
    }

    public void setId(String ... id) {
        this.id = Arrays.asList(id);
    }

    @Override
    public boolean isRemote() {
        return this.getProperty("remote", false);
    }

    public void setRemote(boolean remote) {
        this.setProperty("remote", remote);
    }

    @Override
    public boolean isInteractive() {
        return this.getProperty("interactive", false);
    }

    public void setInteractive(boolean interactive) {
        this.setProperty("interactive", interactive);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public <T> T removeProperty(String key) {
        return (T)this.properties.remove(key);
    }

    @Override
    public <T> T getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public <T> T getProperty(String key, T def) {
        Object value = this.properties.get(key);
        return (T)(value != null ? value : def);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public Boolean isStatusLogIsolated() {
        return this.statusLogIsolated;
    }

    public void setStatusLogIsolated(Boolean statusLogIsolated) {
        this.statusLogIsolated = statusLogIsolated;
    }

    @Override
    public Boolean isStatusSerialized() {
        return this.statusSerialized;
    }

    public void setStatusSerialized(Boolean statusSerialized) {
        this.statusSerialized = statusSerialized;
    }
}

