/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import jakarta.inject.Singleton;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.internal.AbstractJobStatusFolderResolver;

@Component
@Singleton
@Named(value="version3")
@Priority(value=9800)
public class Version3JobStatusFolderResolver
extends AbstractJobStatusFolderResolver {
    private static final int RADIX = 16;
    private static final BitSet SAFE_CHARACTERS;
    private static final int PART_LIMIT = 250;

    @Override
    protected File getBaseFolder() {
        return new File(super.getBaseFolder(), "3");
    }

    @Override
    protected File addIDElement(String fullIdElement, File folder) {
        File result = folder;
        for (String encodedPart : this.encodeAndSplit(fullIdElement)) {
            result = new File(result, encodedPart);
        }
        return result;
    }

    private List<String> encodeAndSplit(String content) {
        if (content == null) {
            return List.of("&null");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder partBuilder = new StringBuilder();
        ByteBuffer inputBuffer = StandardCharsets.UTF_8.encode(content);
        while (inputBuffer.hasRemaining()) {
            int b = inputBuffer.get() & 0xFF;
            if (SAFE_CHARACTERS.get(b) && (b != 46 || Version3JobStatusFolderResolver.shallEncodePeriod(partBuilder.length(), inputBuffer.hasRemaining()))) {
                partBuilder.append((char)b);
            } else {
                partBuilder.append("%");
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                partBuilder.append(hex1);
                partBuilder.append(hex2);
            }
            if (partBuilder.length() < 250) continue;
            result.add(partBuilder.toString());
            partBuilder.setLength(0);
        }
        if (!partBuilder.isEmpty()) {
            result.add(partBuilder.toString());
        }
        return result;
    }

    private static boolean shallEncodePeriod(int outputLength, boolean hasRemaining) {
        return outputLength > 0 && outputLength < 249 && hasRemaining;
    }

    static {
        int i;
        SAFE_CHARACTERS = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            SAFE_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            SAFE_CHARACTERS.set(i);
        }
        SAFE_CHARACTERS.set(45);
        SAFE_CHARACTERS.set(46);
        SAFE_CHARACTERS.set(95);
    }
}

