/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.job.internal;

import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.job.GroupedJobInitializer;
import org.xwiki.job.JobGroupPath;

/**
 * Default implementation of {@link GroupedJobInitializer}.
 * This component provides the default values to use when no initializer is given for a
 * {@link org.xwiki.job.JobGroupPath} hierarchy.
 *
 * @version $Id: e6ed8b71e026d0240664abb54cb4015df31df62a $
 * @since 12.5RC1
 */
@Component
@Singleton
public class DefaultGoupedJobInitializer implements GroupedJobInitializer
{
    @Override
    public JobGroupPath getId()
    {
        // this initializer is valid for any path.
        return null;
    }

    @Override
    public int getPoolSize()
    {
        return 1;
    }

    @Override
    public int getDefaultPriority()
    {
        return Thread.NORM_PRIORITY;
    }
}
