/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.xstream.internal.SafeXStream;

@Component(roles={JobStatusSerializer.class})
@Singleton
public class JobStatusSerializer {
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String ZIP_EXTENSION = "zip";
    @Inject
    private SafeXStream xstream;

    public void write(JobStatus status, File file) throws IOException {
        File tempFile = File.createTempFile(file.getName(), ".tmp");
        try (OutputStream stream = this.getOutputStream(tempFile, this.isZip(file));){
            if (stream instanceof ArchiveOutputStream) {
                ((ArchiveOutputStream)stream).putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("status.xml"));
            }
            this.write(status, stream);
            if (stream instanceof ArchiveOutputStream) {
                ((ArchiveOutputStream)stream).closeArchiveEntry();
            }
        }
        file.mkdirs();
        for (int i = 0; i < 10; ++i) {
            try {
                Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            catch (FileAlreadyExistsException e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ei) {
                    throw e;
                }
            }
        }
    }

    private OutputStream getOutputStream(File tempFile, boolean zip) throws IOException {
        if (zip) {
            return new ZipArchiveOutputStream(tempFile);
        }
        return FileUtils.openOutputStream((File)tempFile);
    }

    public void write(JobStatus status, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, DEFAULT_ENCODING);
        writer.write("<?xml version=\"1.0\" encoding=\"" + DEFAULT_ENCODING.name() + "\"?>\n");
        this.xstream.toXML((Object)status, (Writer)writer);
        writer.flush();
    }

    public JobStatus read(File file) throws IOException {
        if (this.isZip(file)) {
            try (ZipArchiveInputStream stream = new ZipArchiveInputStream((InputStream)new FileInputStream(file));){
                ZipArchiveEntry entry = stream.getNextZipEntry();
                if (entry == null) {
                    throw new IOException("Missing entry in the status zip file");
                }
                JobStatus jobStatus = (JobStatus)this.xstream.fromXML((InputStream)stream);
                return jobStatus;
            }
        }
        return (JobStatus)this.xstream.fromXML(file);
    }

    private boolean isZip(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equals(ZIP_EXTENSION);
    }
}

