/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.EndStepProgressEvent;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.job.event.status.PopLevelProgressEvent;
import org.xwiki.job.event.status.PushLevelProgressEvent;
import org.xwiki.job.event.status.StartStepProgressEvent;
import org.xwiki.job.event.status.StepProgressEvent;
import org.xwiki.logging.Message;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class DefaultJobProgressManager
implements JobProgressManager {
    @Inject
    private ObservationManager observationManager;

    public void pushLevelProgress(Object source) {
        this.observationManager.notify((Event)new PushLevelProgressEvent(), source);
    }

    public void pushLevelProgress(int steps, Object source) {
        this.observationManager.notify((Event)new PushLevelProgressEvent(steps), source);
    }

    @Deprecated
    public void stepPropress(Object source) {
        this.observationManager.notify((Event)StepProgressEvent.INSTANCE, source);
    }

    public void startStep(Object source) {
        this.startStep(source, (Message)null);
    }

    public void startStep(Object source, String name) {
        this.startStep(source, this.toMessage(name));
    }

    public void startStep(Object source, Message message) {
        this.observationManager.notify((Event)StartStepProgressEvent.INSTANCE, source, (Object)message);
    }

    public void startStep(Object source, String translationKey, String message, Object ... arguments) {
        this.startStep(source, this.toMessage(translationKey, message, arguments));
    }

    public void endStep(Object source) {
        this.observationManager.notify((Event)EndStepProgressEvent.INSTANCE, source);
    }

    public void popLevelProgress(Object source) {
        this.observationManager.notify((Event)PopLevelProgressEvent.INSTANCE, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> task, Object source) throws Exception {
        this.pushLevelProgress(source);
        try {
            T t = task.call();
            return t;
        }
        finally {
            this.popLevelProgress(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> task, int steps, Object source) throws Exception {
        this.pushLevelProgress(steps, source);
        try {
            T t = task.call();
            return t;
        }
        finally {
            this.popLevelProgress(source);
        }
    }

    private Message toMessage(String name) {
        return name != null ? new Message(name) : null;
    }

    private Message toMessage(String translationKey, String message, Object[] arguments) {
        return new Message(translationKey, message, arguments);
    }
}

