/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.xwiki.stability.Unstable;

@Unstable
public class ReadWriteSemaphore {
    private final AtomicInteger readCounter;
    private final AtomicInteger writeCounter;
    private final Semaphore semaphore;

    public ReadWriteSemaphore(int poolSize) {
        this.semaphore = new Semaphore(poolSize, true);
        this.readCounter = new AtomicInteger(0);
        this.writeCounter = new AtomicInteger(0);
    }

    public void lockWrite() {
        this.writeCounter.incrementAndGet();
        if (this.writeCounter.get() == 1) {
            this.semaphore.acquireUninterruptibly(this.readCounter.get() + 1);
        } else {
            this.semaphore.acquireUninterruptibly();
        }
    }

    public void unlockWrite() {
        this.writeCounter.decrementAndGet();
        if (this.writeCounter.get() == 0) {
            this.semaphore.release(this.readCounter.get() + 1);
        } else {
            this.semaphore.release();
        }
    }

    public void lockRead() {
        this.readCounter.incrementAndGet();
        if (this.writeCounter.get() > 0) {
            this.semaphore.acquireUninterruptibly();
        }
    }

    public void unlockRead() {
        this.readCounter.decrementAndGet();
        if (this.writeCounter.get() > 0) {
            this.semaphore.release();
        }
    }
}

