/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.job.JobManagerConfiguration;

@Component
@Singleton
public class DefaultJobManagerConfiguration
implements JobManagerConfiguration {
    @Inject
    private Environment environment;
    @Inject
    private Provider<ConfigurationSource> configuration;
    private File store;

    private File getHome() {
        return new File(this.environment.getPermanentDirectory(), "jobs/");
    }

    public File getStorage() {
        if (this.store == null) {
            String localRepositoryPath = (String)((ConfigurationSource)this.configuration.get()).getProperty("job.statusFolder");
            this.store = localRepositoryPath == null ? new File(this.getHome(), "status/") : new File(localRepositoryPath);
        }
        return this.store;
    }

    public int getJobStatusCacheSize() {
        return (Integer)((ConfigurationSource)this.configuration.get()).getProperty("job.statusCacheSize", (Object)50);
    }

    public int getGroupedJobInitializerCacheSize() {
        return (Integer)((ConfigurationSource)this.configuration.get()).getProperty("job.groupedJobInitializerCacheSize", (Object)100);
    }

    public long getSingleJobThreadKeepAliveTime() {
        return (Long)((ConfigurationSource)this.configuration.get()).getProperty("job.singleJobThreadKeepAliveTime", (Object)60000L);
    }

    public long getGroupedJobThreadKeepAliveTime() {
        return (Long)((ConfigurationSource)this.configuration.get()).getProperty("job.groupedJobThreadKeepAliveTime", (Object)60000L);
    }
}

