/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.jakartabridge.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.xwiki.jakartabridge.JakartaBridge;
import org.xwiki.jakartabridge.internal.AbstractJakartaToJavaxWrapper;

public class JakartaToJavaxCollection<C extends Collection<X>, K, X>
extends AbstractJakartaToJavaxWrapper<C>
implements Collection<K> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final Function<K, X> javaxProvider;
    protected final Function<X, K> jakartaProvider;

    public JakartaToJavaxCollection(C wrapped, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        super(wrapped);
        this.javaxProvider = javaxProvider;
        this.jakartaProvider = jakartaProvider;
    }

    @Override
    public int size() {
        return ((Collection)this.getJavax()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.getJavax()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((Collection)this.getJavax()).contains(this.jakartaProvider.apply(o));
    }

    @Override
    public Iterator<K> iterator() {
        return JakartaBridge.toJakarta(((Collection)this.getJavax()).iterator(), this.javaxProvider, this.jakartaProvider);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(EMPTY_OBJECT_ARRAY);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == 0) {
            return a;
        }
        Object[] javaxArray = ((Collection)this.getJavax()).toArray();
        Object[] jakartaArray = (Object[])Array.newInstance(a.getClass().getComponentType(), javaxArray.length);
        for (int i = 0; i < javaxArray.length; ++i) {
            Object javaxObject = javaxArray[i];
            jakartaArray[i] = javaxObject != null ? this.jakartaProvider.apply(javaxObject) : null;
        }
        return jakartaArray;
    }

    @Override
    public boolean add(K e) {
        return ((Collection)this.getJavax()).add(this.javaxProvider.apply(e));
    }

    @Override
    public boolean remove(Object o) {
        return ((Collection)this.getJavax()).remove(this.javaxProvider.apply(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Collection)this.getJavax()).remove(JakartaBridge.toJavax(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        return ((Collection)this.getJavax()).addAll(JakartaBridge.toJavax(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((Collection)this.getJavax()).retainAll(JakartaBridge.toJavax(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ((Collection)this.getJavax()).removeAll(JakartaBridge.toJavax(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public void clear() {
        ((Collection)this.getJavax()).clear();
    }
}

