/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.jakartabridge;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.xwiki.jakartabridge.JakartaToJavaxWrapper;
import org.xwiki.jakartabridge.JavaxToJakartaWrapper;
import org.xwiki.jakartabridge.internal.JakartaToJavaxCollection;
import org.xwiki.jakartabridge.internal.JakartaToJavaxEnumeration;
import org.xwiki.jakartabridge.internal.JakartaToJavaxIterator;
import org.xwiki.jakartabridge.internal.JakartaToJavaxList;
import org.xwiki.jakartabridge.internal.JakartaToJavaxListIterator;
import org.xwiki.jakartabridge.internal.JavaxToJakartaCollection;
import org.xwiki.jakartabridge.internal.JavaxToJakartaEnumeration;
import org.xwiki.jakartabridge.internal.JavaxToJakartaIterator;
import org.xwiki.jakartabridge.internal.JavaxToJakartaList;
import org.xwiki.jakartabridge.internal.JavaxToJakartaListIterator;

public final class JakartaBridge {
    private JakartaBridge() {
    }

    public static <X, K> X toJavax(K jakarta, Function<K, X> javaxProvider) {
        X javax = null;
        if (jakarta != null) {
            if (jakarta instanceof JakartaToJavaxWrapper) {
                JakartaToJavaxWrapper wrapper = (JakartaToJavaxWrapper)jakarta;
                javax = (X)wrapper.getJavax();
            }
            if (javax == null) {
                javax = javaxProvider.apply(jakarta);
            }
        }
        return javax;
    }

    public static <X, K> K toJakarta(X javax, Function<X, K> jakartaConstructor) {
        K jakarta = null;
        if (javax != null) {
            if (javax instanceof JavaxToJakartaWrapper) {
                JavaxToJakartaWrapper wrapper = (JavaxToJakartaWrapper)javax;
                jakarta = (K)wrapper.getJakarta();
            }
            if (jakarta == null) {
                jakarta = jakartaConstructor.apply(javax);
            }
        }
        return jakarta;
    }

    public static <X, K> Collection<X> toJavax(Collection<? extends K> jakarta, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJavax(jakarta, k -> new JavaxToJakartaCollection((Collection)k, javaxProvider, jakartaProvider));
    }

    public static <X, K> Collection<K> toJakarta(Collection<? extends X> javax, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJakarta(javax, x -> new JakartaToJavaxCollection((Collection)x, javaxProvider, jakartaProvider));
    }

    public static <X, K> List<X> toJavax(List<? extends K> jakarta, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJavax(jakarta, k -> new JavaxToJakartaList(k, javaxProvider, jakartaProvider));
    }

    public static <X, K> List<K> toJakarta(List<? extends X> javax, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJakarta(javax, x -> new JakartaToJavaxList(x, javaxProvider, jakartaProvider));
    }

    public static <X, K> Iterator<X> toJavax(Iterator<? extends K> jakarta, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJavax(jakarta, k -> new JavaxToJakartaIterator((Iterator)k, javaxProvider));
    }

    public static <X, K> Iterator<K> toJakarta(Iterator<? extends X> javax, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJakarta(javax, x -> new JakartaToJavaxIterator((Iterator)x, jakartaProvider));
    }

    public static <X, K> Enumeration<X> toJavax(Enumeration<? extends K> jakarta, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJavax(jakarta, k -> new JavaxToJakartaEnumeration((Enumeration)k, javaxProvider, jakartaProvider));
    }

    public static <X, K> Enumeration<K> toJakarta(Enumeration<? extends X> javax, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJakarta(javax, x -> new JakartaToJavaxEnumeration((Enumeration)x, javaxProvider, jakartaProvider));
    }

    public static <X, K> ListIterator<X> toJavax(ListIterator<? extends K> jakarta, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJavax(jakarta, k -> new JavaxToJakartaListIterator(k, javaxProvider, jakartaProvider));
    }

    public static <X, K> ListIterator<K> toJakarta(ListIterator<? extends X> javax, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        return JakartaBridge.toJakarta(javax, x -> new JakartaToJavaxListIterator(x, javaxProvider, jakartaProvider));
    }
}

