/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.http.internal;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.xwiki.http.internal.XWikiCredentials;
import org.xwiki.http.internal.XWikiHTTPClientResponseHandler;

public class XWikiHTTPClient
implements Closeable {
    private static final String DEFAULT_USER_AGENT = "XWiki";
    private final CloseableHttpClient client;
    private XWikiCredentials defaultCredentials;

    public XWikiHTTPClient() {
        this(XWikiHTTPClient.builder());
    }

    public XWikiHTTPClient(String userAgent, int timeout) {
        this(XWikiHTTPClient.builder(userAgent, timeout));
    }

    public XWikiHTTPClient(HttpClientBuilder builder) {
        this.client = builder.build();
    }

    public XWikiHTTPClient(CloseableHttpClient client) {
        this.client = client;
    }

    public static HttpClientBuilder builder() {
        return XWikiHTTPClient.builder(DEFAULT_USER_AGENT);
    }

    public static HttpClientBuilder builder(String userAgent) {
        return HttpClients.custom().useSystemProperties().setUserAgent(userAgent);
    }

    public static HttpClientBuilder builder(String userAgent, int timeout) {
        ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout((long)timeout, TimeUnit.MILLISECONDS).setSocketTimeout(timeout, TimeUnit.MILLISECONDS).build();
        BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager();
        cm.setConnectionConfig(connConfig);
        return XWikiHTTPClient.builder(userAgent).setConnectionManager((HttpClientConnectionManager)cm);
    }

    public void setDefaultCredentials(XWikiCredentials defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    public XWikiCredentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public <T> T execute(ClassicHttpRequest request, XWikiHTTPClientResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request, null, responseHandler);
    }

    public <T> T execute(ClassicHttpRequest request, XWikiCredentials credentials, XWikiHTTPClientResponseHandler<? extends T> responseHandler) throws IOException {
        HttpClientContext context = this.getHttpClientContext((HttpRequest)request, credentials);
        return (T)this.client.execute(request, (HttpContext)context, response -> responseHandler.handleResponse(response, context));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpClientContext getHttpClientContext(HttpRequest request, XWikiCredentials credentials) throws IOException {
        UsernamePasswordCredentials finalCredentials;
        if (credentials == null) {
            if (this.defaultCredentials == null) return null;
            finalCredentials = new UsernamePasswordCredentials(this.defaultCredentials.getUserName(), this.defaultCredentials.getPassword().toCharArray());
        } else {
            finalCredentials = new UsernamePasswordCredentials(credentials.getUserName(), credentials.getPassword().toCharArray());
        }
        try {
            URI uri = request.getUri();
            return ContextBuilder.create().preemptiveBasicAuth(new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort()), finalCredentials).build();
        }
        catch (URISyntaxException e) {
            throw new IOException("Cannot get the URI of the request", e);
        }
    }

    public <T> T executeGet(String uri, XWikiHTTPClientResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute((ClassicHttpRequest)new HttpGet(uri), responseHandler);
    }

    public <T> T executePut(String uri, HttpEntity entity, XWikiHTTPClientResponseHandler<? extends T> responseHandler) throws IOException {
        HttpPut request = new HttpPut(uri);
        request.setEntity(entity);
        return this.execute((ClassicHttpRequest)request, responseHandler);
    }
}

