/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.AbstractRatingExtension;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.DefaultExtensionScmConnection;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.rating.DefaultExtensionRating;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.rating.RatableExtensionRepository;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionDependency;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionFile;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepository;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionDependency;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionRating;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersion;
import org.xwiki.extension.repository.xwiki.model.jaxb.License;
import org.xwiki.extension.repository.xwiki.model.jaxb.Namespaces;
import org.xwiki.extension.repository.xwiki.model.jaxb.Property;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public class XWikiExtension
extends AbstractRatingExtension {
    public XWikiExtension(XWikiExtensionRepository repository, ExtensionVersion restExtension, ExtensionLicenseManager licenseManager) {
        super((ExtensionRepository)repository, new ExtensionId(restExtension.getId(), restExtension.getVersion()), restExtension.getType());
        Boolean recommended;
        org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionIssueManagement restIssueManagement;
        this.setName(restExtension.getName());
        this.setSummary(restExtension.getSummary());
        this.setWebsite(restExtension.getWebsite());
        this.setDescription(restExtension.getDescription());
        for (Object feature : restExtension.getExtensionFeatures()) {
            this.addExtensionFeature(new ExtensionId(feature.getId(), (Version)(feature.getVersion() != null ? new DefaultVersion(feature.getVersion()) : this.getId().getVersion())));
        }
        ExtensionRating restRating = restExtension.getRating();
        if (restRating != null) {
            this.setRating((org.xwiki.extension.rating.ExtensionRating)new DefaultExtensionRating(restRating.getTotalVotes(), restRating.getAverageVote(), (RatableExtensionRepository)this.getRepository()));
        }
        for (org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionAuthor restAuthor : restExtension.getAuthors()) {
            URL url;
            try {
                url = new URL(restAuthor.getUrl());
            }
            catch (MalformedURLException e) {
                url = null;
            }
            this.addAuthor((ExtensionAuthor)new DefaultExtensionAuthor(restAuthor.getName(), url));
        }
        for (License restLicense : restExtension.getLicenses()) {
            if (restLicense.getName() == null) continue;
            ExtensionLicense extensionLicense = licenseManager.getLicense(restLicense.getName());
            if (extensionLicense != null) {
                this.addLicense(extensionLicense);
                continue;
            }
            List content = null;
            if (restLicense.getContent() != null) {
                try {
                    content = IOUtils.readLines((Reader)new StringReader(restLicense.getContent()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.addLicense(new ExtensionLicense(restLicense.getName(), content));
        }
        org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionScm restSCM = restExtension.getScm();
        if (restSCM != null) {
            DefaultExtensionScmConnection connection = XWikiExtension.toDefaultExtensionScmConnection(restSCM.getConnection());
            DefaultExtensionScmConnection developerConnection = XWikiExtension.toDefaultExtensionScmConnection(restSCM.getDeveloperConnection());
            this.setScm((ExtensionScm)new DefaultExtensionScm(restSCM.getUrl(), (ExtensionScmConnection)connection, (ExtensionScmConnection)developerConnection));
        }
        if ((restIssueManagement = restExtension.getIssueManagement()) != null) {
            this.setIssueManagement((ExtensionIssueManagement)new DefaultExtensionIssueManagement(restIssueManagement.getSystem(), restIssueManagement.getUrl()));
        }
        this.setCategory(restExtension.getCategory());
        Namespaces namespaces = restExtension.getAllowedNamespaces();
        if (namespaces != null) {
            this.setAllowedNamespaces(namespaces.getNamespaces());
        }
        if ((recommended = restExtension.isRecommended()) != null) {
            this.setRecommended(restExtension.isRecommended());
        }
        for (Property restProperty : restExtension.getProperties()) {
            this.putProperty(restProperty.getKey(), restProperty.getStringValue());
        }
        if (repository != null) {
            this.addRepository(repository.getDescriptor());
        }
        for (org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionRepository restRepository : restExtension.getRepositories()) {
            try {
                this.addRepository((ExtensionRepositoryDescriptor)XWikiExtension.toDefaultExtensionRepositoryDescriptor(restRepository));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        this.setDependencies(this.toXWikiExtensionDependencies(restExtension.getDependencies()));
        this.setManagedDependencies(this.toXWikiExtensionDependencies(restExtension.getManagedDependencies()));
        this.setFile(new XWikiExtensionFile(repository, this.getId()));
        this.setName(ExtensionUtils.importProperty((AbstractExtension)this, (String)"name", (String)this.getName()));
        this.setSummary(ExtensionUtils.importProperty((AbstractExtension)this, (String)"summary", (String)this.getSummary()));
        this.setWebsite(ExtensionUtils.importProperty((AbstractExtension)this, (String)"website", (String)this.getWebSite()));
        this.setAllowedNamespaces(ExtensionUtils.importProperty((AbstractExtension)this, (String)"namespaces", (Collection)this.getAllowedNamespaces()));
    }

    private Collection<XWikiExtensionDependency> toXWikiExtensionDependencies(List<ExtensionDependency> restDependencies) {
        ArrayList<XWikiExtensionDependency> newDependencies = new ArrayList<XWikiExtensionDependency>(restDependencies.size());
        for (ExtensionDependency dependency : restDependencies) {
            newDependencies.add(new XWikiExtensionDependency(dependency, this.repository != null ? this.repository.getDescriptor() : null));
        }
        return newDependencies;
    }

    protected static DefaultExtensionScmConnection toDefaultExtensionScmConnection(org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionScmConnection connection) {
        if (connection != null) {
            return new DefaultExtensionScmConnection(connection.getSystem(), connection.getPath());
        }
        return null;
    }

    protected static DefaultExtensionRepositoryDescriptor toDefaultExtensionRepositoryDescriptor(org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionRepository restRepository) throws URISyntaxException {
        return new DefaultExtensionRepositoryDescriptor(restRepository.getId(), restRepository.getType(), new URI(restRepository.getUri()));
    }

    public XWikiExtensionRepository getRepository() {
        return (XWikiExtensionRepository)super.getRepository();
    }
}

