/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal.httpclient;

import java.net.ProxySelector;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.repository.xwiki.internal.httpclient.HttpClientFactory;

@Component
@Singleton
public class DefaultHttpClientFactory
implements HttpClientFactory {
    @Inject
    private ExtensionManagerConfiguration configuration;

    @Override
    public HttpClient createClient(String user, String password) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)this.configuration.getUserAgent());
        httpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        httpClient.getParams().setIntParameter("http.connection.timeout", 10000);
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (user != null) {
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        }
        return httpClient;
    }
}

