/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtension;
import org.xwiki.extension.repository.xwiki.internal.XWikiExtensionRepositoryFactory;
import org.xwiki.extension.repository.xwiki.internal.httpclient.HttpClientFactory;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersion;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersionSummary;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionVersions;
import org.xwiki.extension.repository.xwiki.model.jaxb.ExtensionsSearchResult;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.repository.UriBuilder;

public class XWikiExtensionRepository
extends AbstractExtensionRepository
implements Searchable {
    private final transient XWikiExtensionRepositoryFactory repositoryFactory;
    private final transient ExtensionLicenseManager licenseManager;
    private final transient HttpClientFactory httpClientFactory;
    private final transient UriBuilder extensionVersionUriBuider;
    private final transient UriBuilder extensionVersionFileUriBuider;
    private final transient UriBuilder extensionVersionsUriBuider;
    private final transient UriBuilder searchUriBuider;
    private BasicHttpContext localContext;

    public XWikiExtensionRepository(ExtensionRepositoryDescriptor repositoryDescriptor, XWikiExtensionRepositoryFactory repositoryFactory, ExtensionLicenseManager licenseManager, HttpClientFactory httpClientFactory) throws Exception {
        super((ExtensionRepositoryDescriptor)(repositoryDescriptor.getURI().getPath().endsWith("/") ? new DefaultExtensionRepositoryDescriptor(repositoryDescriptor.getId(), repositoryDescriptor.getType(), new URI(StringUtils.chop((String)repositoryDescriptor.getURI().toString()))) : repositoryDescriptor));
        this.repositoryFactory = repositoryFactory;
        this.licenseManager = licenseManager;
        this.httpClientFactory = httpClientFactory;
        this.extensionVersionUriBuider = this.createUriBuilder("/repository/extensions/{extensionId}/versions/{extensionVersion}");
        this.extensionVersionFileUriBuider = this.createUriBuilder("/repository/extensions/{extensionId}/versions/{extensionVersion}/file");
        this.extensionVersionsUriBuider = this.createUriBuilder("/repository/extensions/{extensionId}/versions");
        this.searchUriBuider = this.createUriBuilder("/repository/search");
        if (this.getDescriptor().getProperty("auth.user") != null) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(new HttpHost(this.getDescriptor().getURI().getHost(), this.getDescriptor().getURI().getPort(), this.getDescriptor().getURI().getScheme()), (AuthScheme)basicAuth);
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
    }

    protected UriBuilder getExtensionFileUriBuider() {
        return this.extensionVersionFileUriBuider;
    }

    protected HttpResponse getRESTResource(UriBuilder builder, Object ... values) throws IOException {
        HttpResponse response;
        String url;
        try {
            url = builder.build(values).toString();
        }
        catch (Exception e) {
            throw new IOException("Failed to build REST URL", e);
        }
        HttpClient httpClient = this.httpClientFactory.createClient(this.getDescriptor().getProperty("auth.user"), this.getDescriptor().getProperty("auth.password"));
        HttpGet getMethod = new HttpGet(url);
        getMethod.addHeader("Accept", "application/xml");
        try {
            response = this.localContext != null ? httpClient.execute((HttpUriRequest)getMethod, (HttpContext)this.localContext) : httpClient.execute((HttpUriRequest)getMethod);
        }
        catch (Exception e) {
            throw new IOException("Failed to request [" + getMethod.getURI() + "]", e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid answer (" + response.getStatusLine().getStatusCode() + ") fo the server when requesting");
        }
        return response;
    }

    protected InputStream getRESTResourceAsStream(UriBuilder builder, Object ... values) throws IOException {
        return this.getRESTResource(builder, values).getEntity().getContent();
    }

    private UriBuilder createUriBuilder(String path) {
        return new UriBuilder(this.getDescriptor().getURI(), path);
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        try {
            return new XWikiExtension(this, (ExtensionVersion)this.repositoryFactory.getUnmarshaller().unmarshal(this.getRESTResourceAsStream(this.extensionVersionUriBuider, extensionId.getId(), extensionId.getVersion().getValue())), this.licenseManager);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to create extension object for extension [" + extensionId + "]", (Throwable)e);
        }
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        VersionConstraint constraint = extensionDependency.getVersionConstraint();
        try {
            Version version;
            if (!constraint.getRanges().isEmpty()) {
                ExtensionVersions versions = this.resolveExtensionVersions(extensionDependency.getId(), constraint, 0, -1, false);
                if (versions.getExtensionVersionSummaries().isEmpty()) {
                    throw new ResolveException("Can't find any version with id [" + extensionDependency.getId() + "] matching version constraint [" + extensionDependency.getVersionConstraint() + "]");
                }
                version = new DefaultVersion(((ExtensionVersionSummary)versions.getExtensionVersionSummaries().get(versions.getExtensionVersionSummaries().size() - 1)).getVersion());
            } else {
                version = constraint.getVersion();
            }
            return new XWikiExtension(this, (ExtensionVersion)this.repositoryFactory.getUnmarshaller().unmarshal(this.getRESTResourceAsStream(this.extensionVersionUriBuider, extensionDependency.getId(), version)), this.licenseManager);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to create extension object for extension dependency [" + extensionDependency + "]", (Throwable)e);
        }
    }

    private ExtensionVersions resolveExtensionVersions(String id, VersionConstraint constraint, int offset, int nb, boolean requireTotalHits) throws ResolveException {
        UriBuilder builder = this.extensionVersionsUriBuider.clone();
        builder.queryParam("requireTotalHits", new Object[]{requireTotalHits});
        builder.queryParam("start", new Object[]{offset});
        builder.queryParam("number", new Object[]{nb});
        if (constraint != null) {
            builder.queryParam("versionRanges", new Object[]{constraint.getValue()});
        }
        try {
            return (ExtensionVersions)this.repositoryFactory.getUnmarshaller().unmarshal(this.getRESTResourceAsStream(builder, id));
        }
        catch (Exception e) {
            throw new ResolveException("Failed to find version for extension id [" + id + "]", (Throwable)e);
        }
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        ExtensionVersions restExtensions = this.resolveExtensionVersions(id, null, offset, nb, true);
        ArrayList<DefaultVersion> versions = new ArrayList<DefaultVersion>(restExtensions.getExtensionVersionSummaries().size());
        for (ExtensionVersionSummary restExtension : restExtensions.getExtensionVersionSummaries()) {
            versions.add(new DefaultVersion(restExtension.getVersion()));
        }
        return new CollectionIterableResult(restExtensions.getTotalHits(), restExtensions.getOffset(), versions);
    }

    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        ExtensionsSearchResult restExtensions;
        UriBuilder builder = this.searchUriBuider.clone();
        builder.queryParam("start", new Object[]{offset});
        builder.queryParam("number", new Object[]{nb});
        builder.queryParam("q", new Object[]{pattern});
        try {
            restExtensions = (ExtensionsSearchResult)this.repositoryFactory.getUnmarshaller().unmarshal(this.getRESTResourceAsStream(builder, new Object[0]));
        }
        catch (Exception e) {
            throw new SearchException("Failed to search extensions based on pattern [" + pattern + "]", (Throwable)e);
        }
        ArrayList<XWikiExtension> extensions = new ArrayList<XWikiExtension>(restExtensions.getExtensions().size());
        for (ExtensionVersion restExtension : restExtensions.getExtensions()) {
            extensions.add(new XWikiExtension(this, restExtension, this.licenseManager));
        }
        return new CollectionIterableResult(restExtensions.getTotalHits(), restExtensions.getOffset(), extensions);
    }
}

